@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.RefreshScheduleArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.RefreshScheduleScheduleArgs
import com.pulumi.aws.quicksight.kotlin.inputs.RefreshScheduleScheduleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing a QuickSight Refresh Schedule.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("FULL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("HOURLY")
 *                     .build())
 *                 .build())
 *             .scheduleId("schedule-id")
 *             .build());
 *     }
 * }
 * ```
 * ### With Weekly Refresh
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("INCREMENTAL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("WEEKLY")
 *                     .refreshOnDay(RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs.builder()
 *                         .dayOfWeek("MONDAY")
 *                         .build())
 *                     .timeOfTheDay("01:00")
 *                     .timezone("Europe/London")
 *                     .build())
 *                 .build())
 *             .scheduleId("schedule-id")
 *             .build());
 *     }
 * }
 * ```
 * ### With Monthly Refresh
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("INCREMENTAL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("MONTHLY")
 *                     .refreshOnDay(RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs.builder()
 *                         .dayOfMonth("1")
 *                         .build())
 *                     .timeOfTheDay("01:00")
 *                     .timezone("Europe/London")
 *                     .build())
 *                 .build())
 *             .scheduleId("schedule-id")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a QuickSight Refresh Schedule using the AWS account ID, data set ID and schedule ID separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/refreshSchedule:RefreshSchedule example 123456789012,dataset-id,schedule-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property dataSetId The ID of the dataset.
 * @property schedule The [refresh schedule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshSchedule.html). See schedule
 * The following arguments are optional:
 * @property scheduleId The ID of the refresh schedule.
 */
public data class RefreshScheduleArgs(
    public val awsAccountId: Output<String>? = null,
    public val dataSetId: Output<String>? = null,
    public val schedule: Output<RefreshScheduleScheduleArgs>? = null,
    public val scheduleId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.RefreshScheduleArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.RefreshScheduleArgs =
        com.pulumi.aws.quicksight.RefreshScheduleArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .dataSetId(dataSetId?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scheduleId(scheduleId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RefreshScheduleArgs].
 */
@PulumiTagMarker
public class RefreshScheduleArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var dataSetId: Output<String>? = null

    private var schedule: Output<RefreshScheduleScheduleArgs>? = null

    private var scheduleId: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("ajmyyuksbaoeetit")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value The ID of the dataset.
     */
    @JvmName("behjakiumctogwpr")
    public suspend fun dataSetId(`value`: Output<String>) {
        this.dataSetId = value
    }

    /**
     * @param value The [refresh schedule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshSchedule.html). See schedule
     * The following arguments are optional:
     */
    @JvmName("ldwiiagphgsadssp")
    public suspend fun schedule(`value`: Output<RefreshScheduleScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value The ID of the refresh schedule.
     */
    @JvmName("sumcumclxggrhadj")
    public suspend fun scheduleId(`value`: Output<String>) {
        this.scheduleId = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("lwohmmoscuowrhnh")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value The ID of the dataset.
     */
    @JvmName("afuacuruysnetlcy")
    public suspend fun dataSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetId = mapped
    }

    /**
     * @param value The [refresh schedule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshSchedule.html). See schedule
     * The following arguments are optional:
     */
    @JvmName("chxxkdegkinaynfp")
    public suspend fun schedule(`value`: RefreshScheduleScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument The [refresh schedule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshSchedule.html). See schedule
     * The following arguments are optional:
     */
    @JvmName("yhydmsqoaqadnhwk")
    public suspend fun schedule(argument: suspend RefreshScheduleScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = RefreshScheduleScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value The ID of the refresh schedule.
     */
    @JvmName("ocikucitdtsecmlb")
    public suspend fun scheduleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleId = mapped
    }

    internal fun build(): RefreshScheduleArgs = RefreshScheduleArgs(
        awsAccountId = awsAccountId,
        dataSetId = dataSetId,
        schedule = schedule,
        scheduleId = scheduleId,
    )
}
