@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.TemplatePermission
import com.pulumi.aws.quicksight.kotlin.outputs.TemplateSourceEntity
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.quicksight.kotlin.outputs.TemplatePermission.Companion.toKotlin as templatePermissionToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.TemplateSourceEntity.Companion.toKotlin as templateSourceEntityToKotlin

/**
 * Builder for [Template].
 */
@PulumiTagMarker
public class TemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateArgs = TemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateArgsBuilder.() -> Unit) {
        val builder = TemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Template {
        val builtJavaResource = com.pulumi.aws.quicksight.Template(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Template(builtJavaResource)
    }
}

/**
 * Resource for managing a QuickSight Template.
 * ## Example Usage
 * ### From Source Template
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Template;
 * import com.pulumi.aws.quicksight.TemplateArgs;
 * import com.pulumi.aws.quicksight.inputs.TemplateSourceEntityArgs;
 * import com.pulumi.aws.quicksight.inputs.TemplateSourceEntitySourceTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Template("example", TemplateArgs.builder()
 *             .templateId("example-id")
 *             .versionDescription("version")
 *             .sourceEntity(TemplateSourceEntityArgs.builder()
 *                 .sourceTemplate(TemplateSourceEntitySourceTemplateArgs.builder()
 *                     .arn(aws_quicksight_template.source().arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Definition
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Template;
 * import com.pulumi.aws.quicksight.TemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Template("example", TemplateArgs.builder()
 *             .definition(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .templateId("example-id")
 *             .versionDescription("version")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a QuickSight Template using the AWS account ID and template ID separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/template:Template example 123456789012,example-id
 * ```
 *
 */
public class Template internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.Template,
) : KotlinCustomResource(javaResource, TemplateMapper) {
    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * The time that the template was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The time that the template was last updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * Display name for the template.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    public val permissions: Output<List<TemplatePermission>>?
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> templatePermissionToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    public val sourceEntity: Output<TemplateSourceEntity>?
        get() = javaResource.sourceEntity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    templateSourceEntityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of an analysis or template that was used to create this template.
     */
    public val sourceEntityArn: Output<String>
        get() = javaResource.sourceEntityArn().applyValue({ args0 -> args0 })

    /**
     * The template creation status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Identifier for the template.
     */
    public val templateId: Output<String>
        get() = javaResource.templateId().applyValue({ args0 -> args0 })

    /**
     * A description of the current template version being created/updated.
     * The following arguments are optional:
     */
    public val versionDescription: Output<String>
        get() = javaResource.versionDescription().applyValue({ args0 -> args0 })

    /**
     * The version number of the template version.
     */
    public val versionNumber: Output<Int>
        get() = javaResource.versionNumber().applyValue({ args0 -> args0 })
}

public object TemplateMapper : ResourceMapper<Template> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.Template::class == javaResource::class

    override fun map(javaResource: Resource): Template = Template(
        javaResource as
            com.pulumi.aws.quicksight.Template,
    )
}

/**
 * @see [Template].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Template].
 */
public suspend fun template(name: String, block: suspend TemplateResourceBuilder.() -> Unit):
    Template {
    val builder = TemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Template].
 * @param name The _unique_ name of the resulting resource.
 */
public fun template(name: String): Template {
    val builder = TemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
