@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TemplateAlias].
 */
@PulumiTagMarker
public class TemplateAliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateAliasArgs = TemplateAliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateAliasArgsBuilder.() -> Unit) {
        val builder = TemplateAliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TemplateAlias {
        val builtJavaResource = com.pulumi.aws.quicksight.TemplateAlias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TemplateAlias(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS QuickSight Template Alias.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.TemplateAlias;
 * import com.pulumi.aws.quicksight.TemplateAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TemplateAlias("example", TemplateAliasArgs.builder()
 *             .aliasName("example-alias")
 *             .templateId(aws_quicksight_template.test().template_id())
 *             .templateVersionNumber(aws_quicksight_template.test().version_number())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight Template Alias using the AWS account ID, template ID, and alias name separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/templateAlias:TemplateAlias example 123456789012,example-id,example-alias
 * ```
 *
 */
public class TemplateAlias internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.TemplateAlias,
) : KotlinCustomResource(javaResource, TemplateAliasMapper) {
    /**
     * Display name of the template alias.
     */
    public val aliasName: Output<String>
        get() = javaResource.aliasName().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the template alias.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * ID of the template.
     */
    public val templateId: Output<String>
        get() = javaResource.templateId().applyValue({ args0 -> args0 })

    /**
     * Version number of the template.
     * The following arguments are optional:
     */
    public val templateVersionNumber: Output<Int>
        get() = javaResource.templateVersionNumber().applyValue({ args0 -> args0 })
}

public object TemplateAliasMapper : ResourceMapper<TemplateAlias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.TemplateAlias::class == javaResource::class

    override fun map(javaResource: Resource): TemplateAlias = TemplateAlias(
        javaResource as
            com.pulumi.aws.quicksight.TemplateAlias,
    )
}

/**
 * @see [TemplateAlias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TemplateAlias].
 */
public suspend fun templateAlias(
    name: String,
    block: suspend TemplateAliasResourceBuilder.() -> Unit,
): TemplateAlias {
    val builder = TemplateAliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TemplateAlias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun templateAlias(name: String): TemplateAlias {
    val builder = TemplateAliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
