@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.TemplateAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS QuickSight Template Alias.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.TemplateAlias;
 * import com.pulumi.aws.quicksight.TemplateAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TemplateAlias("example", TemplateAliasArgs.builder()
 *             .aliasName("example-alias")
 *             .templateId(aws_quicksight_template.test().template_id())
 *             .templateVersionNumber(aws_quicksight_template.test().version_number())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight Template Alias using the AWS account ID, template ID, and alias name separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/templateAlias:TemplateAlias example 123456789012,example-id,example-alias
 * ```
 * @property aliasName Display name of the template alias.
 * @property awsAccountId AWS account ID.
 * @property templateId ID of the template.
 * @property templateVersionNumber Version number of the template.
 * The following arguments are optional:
 */
public data class TemplateAliasArgs(
    public val aliasName: Output<String>? = null,
    public val awsAccountId: Output<String>? = null,
    public val templateId: Output<String>? = null,
    public val templateVersionNumber: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.TemplateAliasArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.TemplateAliasArgs =
        com.pulumi.aws.quicksight.TemplateAliasArgs.builder()
            .aliasName(aliasName?.applyValue({ args0 -> args0 }))
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .templateId(templateId?.applyValue({ args0 -> args0 }))
            .templateVersionNumber(templateVersionNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateAliasArgs].
 */
@PulumiTagMarker
public class TemplateAliasArgsBuilder internal constructor() {
    private var aliasName: Output<String>? = null

    private var awsAccountId: Output<String>? = null

    private var templateId: Output<String>? = null

    private var templateVersionNumber: Output<Int>? = null

    /**
     * @param value Display name of the template alias.
     */
    @JvmName("bkneoluktqwjehor")
    public suspend fun aliasName(`value`: Output<String>) {
        this.aliasName = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("vdfvofqxhayddont")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value ID of the template.
     */
    @JvmName("beliacyxmtxbonue")
    public suspend fun templateId(`value`: Output<String>) {
        this.templateId = value
    }

    /**
     * @param value Version number of the template.
     * The following arguments are optional:
     */
    @JvmName("dqsghvqgwbkkmgoc")
    public suspend fun templateVersionNumber(`value`: Output<Int>) {
        this.templateVersionNumber = value
    }

    /**
     * @param value Display name of the template alias.
     */
    @JvmName("nmsklvojoonwfenf")
    public suspend fun aliasName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliasName = mapped
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("bsxnhqvodwdfbetk")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value ID of the template.
     */
    @JvmName("yqphmpbgbsohsedb")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateId = mapped
    }

    /**
     * @param value Version number of the template.
     * The following arguments are optional:
     */
    @JvmName("qahuwiqonkymtfhl")
    public suspend fun templateVersionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateVersionNumber = mapped
    }

    internal fun build(): TemplateAliasArgs = TemplateAliasArgs(
        aliasName = aliasName,
        awsAccountId = awsAccountId,
        templateId = templateId,
        templateVersionNumber = templateVersionNumber,
    )
}
