@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.TemplateArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.TemplatePermissionArgs
import com.pulumi.aws.quicksight.kotlin.inputs.TemplatePermissionArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.TemplateSourceEntityArgs
import com.pulumi.aws.quicksight.kotlin.inputs.TemplateSourceEntityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a QuickSight Template.
 * ## Example Usage
 * ### From Source Template
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Template;
 * import com.pulumi.aws.quicksight.TemplateArgs;
 * import com.pulumi.aws.quicksight.inputs.TemplateSourceEntityArgs;
 * import com.pulumi.aws.quicksight.inputs.TemplateSourceEntitySourceTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Template("example", TemplateArgs.builder()
 *             .templateId("example-id")
 *             .versionDescription("version")
 *             .sourceEntity(TemplateSourceEntityArgs.builder()
 *                 .sourceTemplate(TemplateSourceEntitySourceTemplateArgs.builder()
 *                     .arn(aws_quicksight_template.source().arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Definition
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Template;
 * import com.pulumi.aws.quicksight.TemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Template("example", TemplateArgs.builder()
 *             .definition(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .templateId("example-id")
 *             .versionDescription("version")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a QuickSight Template using the AWS account ID and template ID separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/template:Template example 123456789012,example-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property name Display name for the template.
 * @property permissions A set of resource permissions on the template. Maximum of 64 items. See permissions.
 * @property sourceEntity The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property templateId Identifier for the template.
 * @property versionDescription A description of the current template version being created/updated.
 * The following arguments are optional:
 */
public data class TemplateArgs(
    public val awsAccountId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val permissions: Output<List<TemplatePermissionArgs>>? = null,
    public val sourceEntity: Output<TemplateSourceEntityArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateId: Output<String>? = null,
    public val versionDescription: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.TemplateArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.TemplateArgs =
        com.pulumi.aws.quicksight.TemplateArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceEntity(sourceEntity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateId(templateId?.applyValue({ args0 -> args0 }))
            .versionDescription(versionDescription?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateArgs].
 */
@PulumiTagMarker
public class TemplateArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var name: Output<String>? = null

    private var permissions: Output<List<TemplatePermissionArgs>>? = null

    private var sourceEntity: Output<TemplateSourceEntityArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateId: Output<String>? = null

    private var versionDescription: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("xckriomserojgtpb")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value Display name for the template.
     */
    @JvmName("kgaffwsvaogyepxk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("plvylckuenogmxrt")
    public suspend fun permissions(`value`: Output<List<TemplatePermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("urlyhnpaptdutbnt")
    public suspend fun permissions(vararg values: Output<TemplatePermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("wapjrtoafaxdypql")
    public suspend fun permissions(values: List<Output<TemplatePermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("wntcderuyoghbseb")
    public suspend fun sourceEntity(`value`: Output<TemplateSourceEntityArgs>) {
        this.sourceEntity = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("otbixnaybegcvdlh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Identifier for the template.
     */
    @JvmName("hqyasktgkdmnjftu")
    public suspend fun templateId(`value`: Output<String>) {
        this.templateId = value
    }

    /**
     * @param value A description of the current template version being created/updated.
     * The following arguments are optional:
     */
    @JvmName("jkyyujsvewnjfvyp")
    public suspend fun versionDescription(`value`: Output<String>) {
        this.versionDescription = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("tuxjlgvdnehkslnb")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value Display name for the template.
     */
    @JvmName("gfxjamiubuysrljn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("ovulmmlhmaynbudl")
    public suspend fun permissions(`value`: List<TemplatePermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("xgngvatotovbidji")
    public suspend fun permissions(argument: List<suspend TemplatePermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TemplatePermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("bovemvyddoyorqxo")
    public suspend fun permissions(
        vararg
        argument: suspend TemplatePermissionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TemplatePermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("thykuyfiwgbprfgh")
    public suspend fun permissions(argument: suspend TemplatePermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TemplatePermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("ywpbuntkuqkwnily")
    public suspend fun permissions(vararg values: TemplatePermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("yhdjadbahqdyrgio")
    public suspend fun sourceEntity(`value`: TemplateSourceEntityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEntity = mapped
    }

    /**
     * @param argument The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("rnihytkkbeslkchw")
    public suspend fun sourceEntity(argument: suspend TemplateSourceEntityArgsBuilder.() -> Unit) {
        val toBeMapped = TemplateSourceEntityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceEntity = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kpoukpilhumwtsvq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mgdcprclssrwsmsy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Identifier for the template.
     */
    @JvmName("nscsbldyqbdvufnd")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateId = mapped
    }

    /**
     * @param value A description of the current template version being created/updated.
     * The following arguments are optional:
     */
    @JvmName("fgfkkqmjhnygirtw")
    public suspend fun versionDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionDescription = mapped
    }

    internal fun build(): TemplateArgs = TemplateArgs(
        awsAccountId = awsAccountId,
        name = name,
        permissions = permissions,
        sourceEntity = sourceEntity,
        tags = tags,
        templateId = templateId,
        versionDescription = versionDescription,
    )
}
