@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.ThemeConfiguration
import com.pulumi.aws.quicksight.kotlin.outputs.ThemePermission
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.quicksight.kotlin.outputs.ThemeConfiguration.Companion.toKotlin as themeConfigurationToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.ThemePermission.Companion.toKotlin as themePermissionToKotlin

/**
 * Builder for [Theme].
 */
@PulumiTagMarker
public class ThemeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ThemeArgs = ThemeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ThemeArgsBuilder.() -> Unit) {
        val builder = ThemeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Theme {
        val builtJavaResource = com.pulumi.aws.quicksight.Theme(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Theme(builtJavaResource)
    }
}

/**
 * Resource for managing a QuickSight Theme.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Theme;
 * import com.pulumi.aws.quicksight.ThemeArgs;
 * import com.pulumi.aws.quicksight.inputs.ThemeConfigurationArgs;
 * import com.pulumi.aws.quicksight.inputs.ThemeConfigurationDataColorPaletteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Theme("example", ThemeArgs.builder()
 *             .baseThemeId("MIDNIGHT")
 *             .configuration(ThemeConfigurationArgs.builder()
 *                 .dataColorPalette(ThemeConfigurationDataColorPaletteArgs.builder()
 *                     .colors(
 *                         "#FFFFFF",
 *                         "#111111",
 *                         "#222222",
 *                         "#333333",
 *                         "#444444",
 *                         "#555555",
 *                         "#666666",
 *                         "#777777",
 *                         "#888888",
 *                         "#999999")
 *                     .emptyFillColor("#FFFFFF")
 *                     .minMaxGradient(
 *                         "#FFFFFF",
 *                         "#111111")
 *                     .build())
 *                 .build())
 *             .themeId("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a QuickSight Theme using the AWS account ID and theme ID separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/theme:Theme example 123456789012,example-id
 * ```
 *
 */
public class Theme internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.Theme,
) : KotlinCustomResource(javaResource, ThemeMapper) {
    /**
     * ARN of the theme.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use ListThemes or choose Themes from within an analysis.
     */
    public val baseThemeId: Output<String>
        get() = javaResource.baseThemeId().applyValue({ args0 -> args0 })

    /**
     * The theme configuration, which contains the theme display properties. See configuration.
     * The following arguments are optional:
     */
    public val configuration: Output<ThemeConfiguration>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> themeConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The time that the theme was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The time that the theme was last updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * Display name of the theme.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A set of resource permissions on the theme. Maximum of 64 items. See permissions.
     */
    public val permissions: Output<List<ThemePermission>>?
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> themePermissionToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The theme creation status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Identifier of the theme.
     */
    public val themeId: Output<String>
        get() = javaResource.themeId().applyValue({ args0 -> args0 })

    /**
     * A description of the current theme version being created/updated.
     */
    public val versionDescription: Output<String>?
        get() = javaResource.versionDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version number of the theme version.
     */
    public val versionNumber: Output<Int>
        get() = javaResource.versionNumber().applyValue({ args0 -> args0 })
}

public object ThemeMapper : ResourceMapper<Theme> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.Theme::class == javaResource::class

    override fun map(javaResource: Resource): Theme = Theme(
        javaResource as
            com.pulumi.aws.quicksight.Theme,
    )
}

/**
 * @see [Theme].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Theme].
 */
public suspend fun theme(name: String, block: suspend ThemeResourceBuilder.() -> Unit): Theme {
    val builder = ThemeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Theme].
 * @param name The _unique_ name of the resulting resource.
 */
public fun theme(name: String): Theme {
    val builder = ThemeResourceBuilder()
    builder.name(name)
    return builder.build()
}
