@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.UserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing QuickSight User
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.User;
 * import com.pulumi.aws.quicksight.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .email("author@example.com")
 *             .iamArn("arn:aws:iam::123456789012:user/Example")
 *             .identityType("IAM")
 *             .namespace("foo")
 *             .sessionName("an-author")
 *             .userRole("AUTHOR")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * You cannot import this resource.
 * @property awsAccountId The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
 * @property email The email address of the user that you want to register.
 * @property iamArn The ARN of the IAM user or role that you are registering with Amazon QuickSight.
 * @property identityType Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts either  `IAM` or `QUICKSIGHT`. If `IAM` is specified, the `iam_arn` must also be specified.
 * @property namespace The Amazon Quicksight namespace to create the user in. Defaults to `default`.
 * @property sessionName The name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
 * @property userName The Amazon QuickSight user name that you want to create for the user you are registering. Only valid for registering a user with `identity_type` set to `QUICKSIGHT`.
 * @property userRole The Amazon QuickSight role of the user. The user role can be one of the following: `READER`, `AUTHOR`, or `ADMIN`
 */
public data class UserArgs(
    public val awsAccountId: Output<String>? = null,
    public val email: Output<String>? = null,
    public val iamArn: Output<String>? = null,
    public val identityType: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val sessionName: Output<String>? = null,
    public val userName: Output<String>? = null,
    public val userRole: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.UserArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.UserArgs =
        com.pulumi.aws.quicksight.UserArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .iamArn(iamArn?.applyValue({ args0 -> args0 }))
            .identityType(identityType?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .sessionName(sessionName?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 }))
            .userRole(userRole?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var email: Output<String>? = null

    private var iamArn: Output<String>? = null

    private var identityType: Output<String>? = null

    private var namespace: Output<String>? = null

    private var sessionName: Output<String>? = null

    private var userName: Output<String>? = null

    private var userRole: Output<String>? = null

    /**
     * @param value The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @JvmName("fgktmtetbfhmvnuf")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value The email address of the user that you want to register.
     */
    @JvmName("bvhgxgksmccagmhj")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The ARN of the IAM user or role that you are registering with Amazon QuickSight.
     */
    @JvmName("oqwkjdrbdcqahiil")
    public suspend fun iamArn(`value`: Output<String>) {
        this.iamArn = value
    }

    /**
     * @param value Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts either  `IAM` or `QUICKSIGHT`. If `IAM` is specified, the `iam_arn` must also be specified.
     */
    @JvmName("lqtdvmyroqgjdlss")
    public suspend fun identityType(`value`: Output<String>) {
        this.identityType = value
    }

    /**
     * @param value The Amazon Quicksight namespace to create the user in. Defaults to `default`.
     */
    @JvmName("ghysyjeejkylbxlx")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
     */
    @JvmName("hgpknyyhcyqqadne")
    public suspend fun sessionName(`value`: Output<String>) {
        this.sessionName = value
    }

    /**
     * @param value The Amazon QuickSight user name that you want to create for the user you are registering. Only valid for registering a user with `identity_type` set to `QUICKSIGHT`.
     */
    @JvmName("pcfaebsirgcseohu")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The Amazon QuickSight role of the user. The user role can be one of the following: `READER`, `AUTHOR`, or `ADMIN`
     */
    @JvmName("hxaoypbuostoonbr")
    public suspend fun userRole(`value`: Output<String>) {
        this.userRole = value
    }

    /**
     * @param value The ID for the AWS account that the user is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @JvmName("tokhivvqbxfgyvxd")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value The email address of the user that you want to register.
     */
    @JvmName("earcgvgtrwdsrext")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value The ARN of the IAM user or role that you are registering with Amazon QuickSight.
     */
    @JvmName("blcnhulerstielhs")
    public suspend fun iamArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamArn = mapped
    }

    /**
     * @param value Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts either  `IAM` or `QUICKSIGHT`. If `IAM` is specified, the `iam_arn` must also be specified.
     */
    @JvmName("webpklvmyjosridy")
    public suspend fun identityType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityType = mapped
    }

    /**
     * @param value The Amazon Quicksight namespace to create the user in. Defaults to `default`.
     */
    @JvmName("lqtehrtiyxwjsvev")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The name of the IAM session to use when assuming roles that can embed QuickSight dashboards. Only valid for registering users using an assumed IAM role. Additionally, if registering multiple users using the same IAM role, each user needs to have a unique session name.
     */
    @JvmName("hnlnwpfbltnggnlk")
    public suspend fun sessionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionName = mapped
    }

    /**
     * @param value The Amazon QuickSight user name that you want to create for the user you are registering. Only valid for registering a user with `identity_type` set to `QUICKSIGHT`.
     */
    @JvmName("lkgmklousktcuqyy")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    /**
     * @param value The Amazon QuickSight role of the user. The user role can be one of the following: `READER`, `AUTHOR`, or `ADMIN`
     */
    @JvmName("cxodetsydeukpnpd")
    public suspend fun userRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userRole = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        awsAccountId = awsAccountId,
        email = email,
        iamArn = iamArn,
        identityType = identityType,
        namespace = namespace,
        sessionName = sessionName,
        userName = userName,
        userRole = userRole,
    )
}
