@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.VpcConnectionTimeouts
import com.pulumi.aws.quicksight.kotlin.outputs.VpcConnectionTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcConnection].
 */
@PulumiTagMarker
public class VpcConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcConnectionArgs = VpcConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcConnectionArgsBuilder.() -> Unit) {
        val builder = VpcConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcConnection {
        val builtJavaResource = com.pulumi.aws.quicksight.VpcConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcConnection(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS QuickSight VPC Connection.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import com.pulumi.aws.quicksight.VpcConnection;
 * import com.pulumi.aws.quicksight.VpcConnectionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpcConnectionRole = new Role("vpcConnectionRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "quicksight.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .inlinePolicies(RoleInlinePolicyArgs.builder()
 *                 .name("QuickSightVPCConnectionRolePolicy")
 *                 .policy(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("Version", "2012-10-17"),
 *                         jsonProperty("Statement", jsonArray(jsonObject(
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Action", jsonArray(
 *                                 "ec2:CreateNetworkInterface",
 *                                 "ec2:ModifyNetworkInterfaceAttribute",
 *                                 "ec2:DeleteNetworkInterface",
 *                                 "ec2:DescribeSubnets",
 *                                 "ec2:DescribeSecurityGroups"
 *                             )),
 *                             jsonProperty("Resource", jsonArray("*"))
 *                         )))
 *                     )))
 *                 .build())
 *             .build());
 *         var example = new VpcConnection("example", VpcConnectionArgs.builder()
 *             .vpcConnectionId("example-connection-id")
 *             .roleArn(vpcConnectionRole.arn())
 *             .securityGroupIds("sg-00000000000000000")
 *             .subnetIds(
 *                 "subnet-00000000000000000",
 *                 "subnet-00000000000000001")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight VPC connection using the AWS account ID and VPC connection ID separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/vpcConnection:VpcConnection example 123456789012,example
 * ```
 *
 */
public class VpcConnection internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.VpcConnection,
) : KotlinCustomResource(javaResource, VpcConnectionMapper) {
    /**
     * ARN of the VPC connection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The availability status of the VPC connection. Valid values are `AVAILABLE`, `UNAVAILABLE` or `PARTIALLY_AVAILABLE`.
     */
    public val availabilityStatus: Output<String>
        get() = javaResource.availabilityStatus().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * A list of IP addresses of DNS resolver endpoints for the VPC connection.
     */
    public val dnsResolvers: Output<List<String>>?
        get() = javaResource.dnsResolvers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The display name for the VPC connection.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The IAM role to associate with the VPC connection.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * A list of security group IDs for the VPC connection.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of subnet IDs for the VPC connection.
     * The following arguments are optional:
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<VpcConnectionTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ID of the VPC connection.
     */
    public val vpcConnectionId: Output<String>
        get() = javaResource.vpcConnectionId().applyValue({ args0 -> args0 })
}

public object VpcConnectionMapper : ResourceMapper<VpcConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.VpcConnection::class == javaResource::class

    override fun map(javaResource: Resource): VpcConnection = VpcConnection(
        javaResource as
            com.pulumi.aws.quicksight.VpcConnection,
    )
}

/**
 * @see [VpcConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcConnection].
 */
public suspend fun vpcConnection(
    name: String,
    block: suspend VpcConnectionResourceBuilder.() -> Unit,
): VpcConnection {
    val builder = VpcConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcConnection(name: String): VpcConnection {
    val builder = VpcConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
