@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.VpcConnectionArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.VpcConnectionTimeoutsArgs
import com.pulumi.aws.quicksight.kotlin.inputs.VpcConnectionTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS QuickSight VPC Connection.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import com.pulumi.aws.quicksight.VpcConnection;
 * import com.pulumi.aws.quicksight.VpcConnectionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpcConnectionRole = new Role("vpcConnectionRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "quicksight.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .inlinePolicies(RoleInlinePolicyArgs.builder()
 *                 .name("QuickSightVPCConnectionRolePolicy")
 *                 .policy(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("Version", "2012-10-17"),
 *                         jsonProperty("Statement", jsonArray(jsonObject(
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Action", jsonArray(
 *                                 "ec2:CreateNetworkInterface",
 *                                 "ec2:ModifyNetworkInterfaceAttribute",
 *                                 "ec2:DeleteNetworkInterface",
 *                                 "ec2:DescribeSubnets",
 *                                 "ec2:DescribeSecurityGroups"
 *                             )),
 *                             jsonProperty("Resource", jsonArray("*"))
 *                         )))
 *                     )))
 *                 .build())
 *             .build());
 *         var example = new VpcConnection("example", VpcConnectionArgs.builder()
 *             .vpcConnectionId("example-connection-id")
 *             .roleArn(vpcConnectionRole.arn())
 *             .securityGroupIds("sg-00000000000000000")
 *             .subnetIds(
 *                 "subnet-00000000000000000",
 *                 "subnet-00000000000000001")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import QuickSight VPC connection using the AWS account ID and VPC connection ID separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:quicksight/vpcConnection:VpcConnection example 123456789012,example
 * ```
 * @property awsAccountId AWS account ID.
 * @property dnsResolvers A list of IP addresses of DNS resolver endpoints for the VPC connection.
 * @property name The display name for the VPC connection.
 * @property roleArn The IAM role to associate with the VPC connection.
 * @property securityGroupIds A list of security group IDs for the VPC connection.
 * @property subnetIds A list of subnet IDs for the VPC connection.
 * The following arguments are optional:
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 * @property vpcConnectionId The ID of the VPC connection.
 */
public data class VpcConnectionArgs(
    public val awsAccountId: Output<String>? = null,
    public val dnsResolvers: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<VpcConnectionTimeoutsArgs>? = null,
    public val vpcConnectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.VpcConnectionArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.VpcConnectionArgs =
        com.pulumi.aws.quicksight.VpcConnectionArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .dnsResolvers(dnsResolvers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcConnectionId(vpcConnectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcConnectionArgs].
 */
@PulumiTagMarker
public class VpcConnectionArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var dnsResolvers: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<VpcConnectionTimeoutsArgs>? = null

    private var vpcConnectionId: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("glstqbtdbjtjkdlo")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value A list of IP addresses of DNS resolver endpoints for the VPC connection.
     */
    @JvmName("mkdexdstmvvqeuaj")
    public suspend fun dnsResolvers(`value`: Output<List<String>>) {
        this.dnsResolvers = value
    }

    @JvmName("cmvocongksdjbdih")
    public suspend fun dnsResolvers(vararg values: Output<String>) {
        this.dnsResolvers = Output.all(values.asList())
    }

    /**
     * @param values A list of IP addresses of DNS resolver endpoints for the VPC connection.
     */
    @JvmName("uhoomlklofdnpkho")
    public suspend fun dnsResolvers(values: List<Output<String>>) {
        this.dnsResolvers = Output.all(values)
    }

    /**
     * @param value The display name for the VPC connection.
     */
    @JvmName("npeopfbxvoplmqgr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IAM role to associate with the VPC connection.
     */
    @JvmName("xiandjtmapviftbq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A list of security group IDs for the VPC connection.
     */
    @JvmName("ghlnqusvftkbhkub")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("pqybltbdmdatqxfg")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs for the VPC connection.
     */
    @JvmName("fetuihknutnbidhc")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value A list of subnet IDs for the VPC connection.
     * The following arguments are optional:
     */
    @JvmName("pgcsqxkngimlyrch")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("ooibljgjhlehqtmr")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs for the VPC connection.
     * The following arguments are optional:
     */
    @JvmName("gsgoikmuywxqpfvw")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("waoillfrdmugkkle")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ayobriyhlkppqcmi")
    public suspend fun timeouts(`value`: Output<VpcConnectionTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The ID of the VPC connection.
     */
    @JvmName("kwfqypneesgqaqgv")
    public suspend fun vpcConnectionId(`value`: Output<String>) {
        this.vpcConnectionId = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("xnhgecfetcyulnva")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value A list of IP addresses of DNS resolver endpoints for the VPC connection.
     */
    @JvmName("cljockalxrrsulli")
    public suspend fun dnsResolvers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsResolvers = mapped
    }

    /**
     * @param values A list of IP addresses of DNS resolver endpoints for the VPC connection.
     */
    @JvmName("hmywsfxpbfedlkdb")
    public suspend fun dnsResolvers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsResolvers = mapped
    }

    /**
     * @param value The display name for the VPC connection.
     */
    @JvmName("rmmfgefllqcmqwok")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The IAM role to associate with the VPC connection.
     */
    @JvmName("awlifkcdnqpsmbcx")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A list of security group IDs for the VPC connection.
     */
    @JvmName("vgmomcnhjapvocdj")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of security group IDs for the VPC connection.
     */
    @JvmName("dfiywfjkwjvnsvaf")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value A list of subnet IDs for the VPC connection.
     * The following arguments are optional:
     */
    @JvmName("vftkmpfirtvisnjr")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of subnet IDs for the VPC connection.
     * The following arguments are optional:
     */
    @JvmName("skvgsutghqgwhyed")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uyqgmmlmesdxxdrx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("whqusqcmccvjqhvo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("cxvcyeklfxojdqih")
    public suspend fun timeouts(`value`: VpcConnectionTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qrqntwddhwhkwcvl")
    public suspend fun timeouts(argument: suspend VpcConnectionTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = VpcConnectionTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value The ID of the VPC connection.
     */
    @JvmName("rxhyaudgemsailiw")
    public suspend fun vpcConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConnectionId = mapped
    }

    internal fun build(): VpcConnectionArgs = VpcConnectionArgs(
        awsAccountId = awsAccountId,
        dnsResolvers = dnsResolvers,
        name = name,
        roleArn = roleArn,
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds,
        tags = tags,
        timeouts = timeouts,
        vpcConnectionId = vpcConnectionId,
    )
}
