@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.AnalysisParametersIntegerParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Display name for the analysis.
 * The following arguments are optional:
 * @property values
 */
public data class AnalysisParametersIntegerParameterArgs(
    public val name: Output<String>,
    public val values: Output<List<Int>>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.AnalysisParametersIntegerParameterArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.AnalysisParametersIntegerParameterArgs =
        com.pulumi.aws.quicksight.inputs.AnalysisParametersIntegerParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AnalysisParametersIntegerParameterArgs].
 */
@PulumiTagMarker
public class AnalysisParametersIntegerParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var values: Output<List<Int>>? = null

    /**
     * @param value Display name for the analysis.
     * The following arguments are optional:
     */
    @JvmName("wmtegqxwrqbnpirx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("yenefsrksnmjglxa")
    public suspend fun values(`value`: Output<List<Int>>) {
        this.values = value
    }

    @JvmName("jgeqxrbvpembscyr")
    public suspend fun values(vararg values: Output<Int>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("nqkdnephasaaeibg")
    public suspend fun values(values: List<Output<Int>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Display name for the analysis.
     * The following arguments are optional:
     */
    @JvmName("vwpculgjambhpnqi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("ffaatxkwqovtnbcm")
    public suspend fun values(`value`: List<Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("lnmygskjwmlgssae")
    public suspend fun values(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): AnalysisParametersIntegerParameterArgs =
        AnalysisParametersIntegerParameterArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            values = values ?: throw PulumiNullFieldException("values"),
        )
}
