@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.AnalysisSourceEntityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sourceTemplate The source template. See source_template.
 */
public data class AnalysisSourceEntityArgs(
    public val sourceTemplate: Output<AnalysisSourceEntitySourceTemplateArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.AnalysisSourceEntityArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.AnalysisSourceEntityArgs =
        com.pulumi.aws.quicksight.inputs.AnalysisSourceEntityArgs.builder()
            .sourceTemplate(
                sourceTemplate?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AnalysisSourceEntityArgs].
 */
@PulumiTagMarker
public class AnalysisSourceEntityArgsBuilder internal constructor() {
    private var sourceTemplate: Output<AnalysisSourceEntitySourceTemplateArgs>? = null

    /**
     * @param value The source template. See source_template.
     */
    @JvmName("irywmolmvorirvky")
    public suspend fun sourceTemplate(`value`: Output<AnalysisSourceEntitySourceTemplateArgs>) {
        this.sourceTemplate = value
    }

    /**
     * @param value The source template. See source_template.
     */
    @JvmName("nrrksaeacjgndgmd")
    public suspend fun sourceTemplate(`value`: AnalysisSourceEntitySourceTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceTemplate = mapped
    }

    /**
     * @param argument The source template. See source_template.
     */
    @JvmName("antsbidagfsekswl")
    public suspend
    fun sourceTemplate(argument: suspend AnalysisSourceEntitySourceTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = AnalysisSourceEntitySourceTemplateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sourceTemplate = mapped
    }

    internal fun build(): AnalysisSourceEntityArgs = AnalysisSourceEntityArgs(
        sourceTemplate = sourceTemplate,
    )
}
