@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DashboardDashboardPublishOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property adHocFilteringOption Ad hoc (one-time) filtering option. See ad_hoc_filtering_option.
 * @property dataPointDrillUpDownOption The drill-down options of data points in a dashboard. See data_point_drill_up_down_option.
 * @property dataPointMenuLabelOption The data point menu label options of a dashboard. See data_point_menu_label_option.
 * @property dataPointTooltipOption The data point tool tip options of a dashboard. See data_point_tooltip_option.
 * @property exportToCsvOption Export to .csv option. See export_to_csv_option.
 * @property exportWithHiddenFieldsOption Determines if hidden fields are exported with a dashboard. See export_with_hidden_fields_option.
 * @property sheetControlsOption Sheet controls option. See sheet_controls_option.
 * @property sheetLayoutElementMaximizationOption The sheet layout maximization options of a dashboard. See sheet_layout_element_maximization_option.
 * @property visualAxisSortOption The axis sort options of a dashboard. See visual_axis_sort_option.
 * @property visualMenuOption The menu options of a visual in a dashboard. See visual_menu_option.
 */
public data class DashboardDashboardPublishOptionsArgs(
    public val adHocFilteringOption: Output<DashboardDashboardPublishOptionsAdHocFilteringOptionArgs>? =
        null,
    public val dataPointDrillUpDownOption:
    Output<DashboardDashboardPublishOptionsDataPointDrillUpDownOptionArgs>? = null,
    public val dataPointMenuLabelOption:
    Output<DashboardDashboardPublishOptionsDataPointMenuLabelOptionArgs>? = null,
    public val dataPointTooltipOption:
    Output<DashboardDashboardPublishOptionsDataPointTooltipOptionArgs>? = null,
    public val exportToCsvOption: Output<DashboardDashboardPublishOptionsExportToCsvOptionArgs>? =
        null,
    public val exportWithHiddenFieldsOption:
    Output<DashboardDashboardPublishOptionsExportWithHiddenFieldsOptionArgs>? = null,
    public val sheetControlsOption: Output<DashboardDashboardPublishOptionsSheetControlsOptionArgs>? =
        null,
    public val sheetLayoutElementMaximizationOption:
    Output<DashboardDashboardPublishOptionsSheetLayoutElementMaximizationOptionArgs>? = null,
    public val visualAxisSortOption: Output<DashboardDashboardPublishOptionsVisualAxisSortOptionArgs>? =
        null,
    public val visualMenuOption: Output<DashboardDashboardPublishOptionsVisualMenuOptionArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DashboardDashboardPublishOptionsArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DashboardDashboardPublishOptionsArgs =
        com.pulumi.aws.quicksight.inputs.DashboardDashboardPublishOptionsArgs.builder()
            .adHocFilteringOption(
                adHocFilteringOption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataPointDrillUpDownOption(
                dataPointDrillUpDownOption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataPointMenuLabelOption(
                dataPointMenuLabelOption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataPointTooltipOption(
                dataPointTooltipOption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .exportToCsvOption(exportToCsvOption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .exportWithHiddenFieldsOption(
                exportWithHiddenFieldsOption?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sheetControlsOption(
                sheetControlsOption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sheetLayoutElementMaximizationOption(
                sheetLayoutElementMaximizationOption?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .visualAxisSortOption(
                visualAxisSortOption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .visualMenuOption(
                visualMenuOption?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DashboardDashboardPublishOptionsArgs].
 */
@PulumiTagMarker
public class DashboardDashboardPublishOptionsArgsBuilder internal constructor() {
    private var adHocFilteringOption:
        Output<DashboardDashboardPublishOptionsAdHocFilteringOptionArgs>? = null

    private var dataPointDrillUpDownOption:
        Output<DashboardDashboardPublishOptionsDataPointDrillUpDownOptionArgs>? = null

    private var dataPointMenuLabelOption:
        Output<DashboardDashboardPublishOptionsDataPointMenuLabelOptionArgs>? = null

    private var dataPointTooltipOption:
        Output<DashboardDashboardPublishOptionsDataPointTooltipOptionArgs>? = null

    private var exportToCsvOption: Output<DashboardDashboardPublishOptionsExportToCsvOptionArgs>? =
        null

    private var exportWithHiddenFieldsOption:
        Output<DashboardDashboardPublishOptionsExportWithHiddenFieldsOptionArgs>? = null

    private var sheetControlsOption: Output<DashboardDashboardPublishOptionsSheetControlsOptionArgs>? =
        null

    private var sheetLayoutElementMaximizationOption:
        Output<DashboardDashboardPublishOptionsSheetLayoutElementMaximizationOptionArgs>? = null

    private var visualAxisSortOption:
        Output<DashboardDashboardPublishOptionsVisualAxisSortOptionArgs>? = null

    private var visualMenuOption: Output<DashboardDashboardPublishOptionsVisualMenuOptionArgs>? = null

    /**
     * @param value Ad hoc (one-time) filtering option. See ad_hoc_filtering_option.
     */
    @JvmName("culjjipdtvpgdjvk")
    public suspend
    fun adHocFilteringOption(`value`: Output<DashboardDashboardPublishOptionsAdHocFilteringOptionArgs>) {
        this.adHocFilteringOption = value
    }

    /**
     * @param value The drill-down options of data points in a dashboard. See data_point_drill_up_down_option.
     */
    @JvmName("gyumsvxrwyprfimt")
    public suspend
    fun dataPointDrillUpDownOption(`value`: Output<DashboardDashboardPublishOptionsDataPointDrillUpDownOptionArgs>) {
        this.dataPointDrillUpDownOption = value
    }

    /**
     * @param value The data point menu label options of a dashboard. See data_point_menu_label_option.
     */
    @JvmName("urfpljrnmbxnrcna")
    public suspend
    fun dataPointMenuLabelOption(`value`: Output<DashboardDashboardPublishOptionsDataPointMenuLabelOptionArgs>) {
        this.dataPointMenuLabelOption = value
    }

    /**
     * @param value The data point tool tip options of a dashboard. See data_point_tooltip_option.
     */
    @JvmName("ovextqkaaemgotcx")
    public suspend
    fun dataPointTooltipOption(`value`: Output<DashboardDashboardPublishOptionsDataPointTooltipOptionArgs>) {
        this.dataPointTooltipOption = value
    }

    /**
     * @param value Export to .csv option. See export_to_csv_option.
     */
    @JvmName("kccnxapfbdhvnqqu")
    public suspend
    fun exportToCsvOption(`value`: Output<DashboardDashboardPublishOptionsExportToCsvOptionArgs>) {
        this.exportToCsvOption = value
    }

    /**
     * @param value Determines if hidden fields are exported with a dashboard. See export_with_hidden_fields_option.
     */
    @JvmName("fbpegswchdaixrle")
    public suspend
    fun exportWithHiddenFieldsOption(`value`: Output<DashboardDashboardPublishOptionsExportWithHiddenFieldsOptionArgs>) {
        this.exportWithHiddenFieldsOption = value
    }

    /**
     * @param value Sheet controls option. See sheet_controls_option.
     */
    @JvmName("wmfhnhscxlurxfqg")
    public suspend
    fun sheetControlsOption(`value`: Output<DashboardDashboardPublishOptionsSheetControlsOptionArgs>) {
        this.sheetControlsOption = value
    }

    /**
     * @param value The sheet layout maximization options of a dashboard. See sheet_layout_element_maximization_option.
     */
    @JvmName("gtmgbornidtbnhwm")
    public suspend
    fun sheetLayoutElementMaximizationOption(`value`: Output<DashboardDashboardPublishOptionsSheetLayoutElementMaximizationOptionArgs>) {
        this.sheetLayoutElementMaximizationOption = value
    }

    /**
     * @param value The axis sort options of a dashboard. See visual_axis_sort_option.
     */
    @JvmName("vvxjdymqjotsbgqb")
    public suspend
    fun visualAxisSortOption(`value`: Output<DashboardDashboardPublishOptionsVisualAxisSortOptionArgs>) {
        this.visualAxisSortOption = value
    }

    /**
     * @param value The menu options of a visual in a dashboard. See visual_menu_option.
     */
    @JvmName("bhadjxfkfsacnlus")
    public suspend
    fun visualMenuOption(`value`: Output<DashboardDashboardPublishOptionsVisualMenuOptionArgs>) {
        this.visualMenuOption = value
    }

    /**
     * @param value Ad hoc (one-time) filtering option. See ad_hoc_filtering_option.
     */
    @JvmName("roajgpitrvynqvmt")
    public suspend
    fun adHocFilteringOption(`value`: DashboardDashboardPublishOptionsAdHocFilteringOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adHocFilteringOption = mapped
    }

    /**
     * @param argument Ad hoc (one-time) filtering option. See ad_hoc_filtering_option.
     */
    @JvmName("oiddlehtivfisjch")
    public suspend
    fun adHocFilteringOption(argument: suspend DashboardDashboardPublishOptionsAdHocFilteringOptionArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardDashboardPublishOptionsAdHocFilteringOptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.adHocFilteringOption = mapped
    }

    /**
     * @param value The drill-down options of data points in a dashboard. See data_point_drill_up_down_option.
     */
    @JvmName("lfdcvqqoybkjldqp")
    public suspend
    fun dataPointDrillUpDownOption(`value`: DashboardDashboardPublishOptionsDataPointDrillUpDownOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPointDrillUpDownOption = mapped
    }

    /**
     * @param argument The drill-down options of data points in a dashboard. See data_point_drill_up_down_option.
     */
    @JvmName("vhbqtrxejxljgmts")
    public suspend
    fun dataPointDrillUpDownOption(argument: suspend DashboardDashboardPublishOptionsDataPointDrillUpDownOptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DashboardDashboardPublishOptionsDataPointDrillUpDownOptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dataPointDrillUpDownOption = mapped
    }

    /**
     * @param value The data point menu label options of a dashboard. See data_point_menu_label_option.
     */
    @JvmName("rgfvcxbxekrulopg")
    public suspend
    fun dataPointMenuLabelOption(`value`: DashboardDashboardPublishOptionsDataPointMenuLabelOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPointMenuLabelOption = mapped
    }

    /**
     * @param argument The data point menu label options of a dashboard. See data_point_menu_label_option.
     */
    @JvmName("qbnlwllkiwhrkqui")
    public suspend
    fun dataPointMenuLabelOption(argument: suspend DashboardDashboardPublishOptionsDataPointMenuLabelOptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DashboardDashboardPublishOptionsDataPointMenuLabelOptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dataPointMenuLabelOption = mapped
    }

    /**
     * @param value The data point tool tip options of a dashboard. See data_point_tooltip_option.
     */
    @JvmName("nqfdxwortaitwaee")
    public suspend
    fun dataPointTooltipOption(`value`: DashboardDashboardPublishOptionsDataPointTooltipOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPointTooltipOption = mapped
    }

    /**
     * @param argument The data point tool tip options of a dashboard. See data_point_tooltip_option.
     */
    @JvmName("bchtyyfpjuworcft")
    public suspend
    fun dataPointTooltipOption(argument: suspend DashboardDashboardPublishOptionsDataPointTooltipOptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DashboardDashboardPublishOptionsDataPointTooltipOptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dataPointTooltipOption = mapped
    }

    /**
     * @param value Export to .csv option. See export_to_csv_option.
     */
    @JvmName("rsccwprqsdyvfnga")
    public suspend
    fun exportToCsvOption(`value`: DashboardDashboardPublishOptionsExportToCsvOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportToCsvOption = mapped
    }

    /**
     * @param argument Export to .csv option. See export_to_csv_option.
     */
    @JvmName("oiwoeajafohbaqsr")
    public suspend
    fun exportToCsvOption(argument: suspend DashboardDashboardPublishOptionsExportToCsvOptionArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardDashboardPublishOptionsExportToCsvOptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.exportToCsvOption = mapped
    }

    /**
     * @param value Determines if hidden fields are exported with a dashboard. See export_with_hidden_fields_option.
     */
    @JvmName("kqaffdwtlgruevyn")
    public suspend
    fun exportWithHiddenFieldsOption(`value`: DashboardDashboardPublishOptionsExportWithHiddenFieldsOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportWithHiddenFieldsOption = mapped
    }

    /**
     * @param argument Determines if hidden fields are exported with a dashboard. See export_with_hidden_fields_option.
     */
    @JvmName("fqygefkhgwfdjetg")
    public suspend
    fun exportWithHiddenFieldsOption(argument: suspend DashboardDashboardPublishOptionsExportWithHiddenFieldsOptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DashboardDashboardPublishOptionsExportWithHiddenFieldsOptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.exportWithHiddenFieldsOption = mapped
    }

    /**
     * @param value Sheet controls option. See sheet_controls_option.
     */
    @JvmName("vfawtnygssuyksao")
    public suspend
    fun sheetControlsOption(`value`: DashboardDashboardPublishOptionsSheetControlsOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sheetControlsOption = mapped
    }

    /**
     * @param argument Sheet controls option. See sheet_controls_option.
     */
    @JvmName("haofjwhumlulxbbe")
    public suspend
    fun sheetControlsOption(argument: suspend DashboardDashboardPublishOptionsSheetControlsOptionArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardDashboardPublishOptionsSheetControlsOptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sheetControlsOption = mapped
    }

    /**
     * @param value The sheet layout maximization options of a dashboard. See sheet_layout_element_maximization_option.
     */
    @JvmName("oytsiiaeqkpbmrnt")
    public suspend
    fun sheetLayoutElementMaximizationOption(`value`: DashboardDashboardPublishOptionsSheetLayoutElementMaximizationOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sheetLayoutElementMaximizationOption = mapped
    }

    /**
     * @param argument The sheet layout maximization options of a dashboard. See sheet_layout_element_maximization_option.
     */
    @JvmName("ufkpwglvwshobsvl")
    public suspend
    fun sheetLayoutElementMaximizationOption(argument: suspend DashboardDashboardPublishOptionsSheetLayoutElementMaximizationOptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DashboardDashboardPublishOptionsSheetLayoutElementMaximizationOptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sheetLayoutElementMaximizationOption = mapped
    }

    /**
     * @param value The axis sort options of a dashboard. See visual_axis_sort_option.
     */
    @JvmName("bqdyhnuxyloicems")
    public suspend
    fun visualAxisSortOption(`value`: DashboardDashboardPublishOptionsVisualAxisSortOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visualAxisSortOption = mapped
    }

    /**
     * @param argument The axis sort options of a dashboard. See visual_axis_sort_option.
     */
    @JvmName("jqobyihxaivtmovh")
    public suspend
    fun visualAxisSortOption(argument: suspend DashboardDashboardPublishOptionsVisualAxisSortOptionArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardDashboardPublishOptionsVisualAxisSortOptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.visualAxisSortOption = mapped
    }

    /**
     * @param value The menu options of a visual in a dashboard. See visual_menu_option.
     */
    @JvmName("adusyuyuhhdogfji")
    public suspend
    fun visualMenuOption(`value`: DashboardDashboardPublishOptionsVisualMenuOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visualMenuOption = mapped
    }

    /**
     * @param argument The menu options of a visual in a dashboard. See visual_menu_option.
     */
    @JvmName("mpqeepenwhhuqksh")
    public suspend
    fun visualMenuOption(argument: suspend DashboardDashboardPublishOptionsVisualMenuOptionArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardDashboardPublishOptionsVisualMenuOptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.visualMenuOption = mapped
    }

    internal fun build(): DashboardDashboardPublishOptionsArgs = DashboardDashboardPublishOptionsArgs(
        adHocFilteringOption = adHocFilteringOption,
        dataPointDrillUpDownOption = dataPointDrillUpDownOption,
        dataPointMenuLabelOption = dataPointMenuLabelOption,
        dataPointTooltipOption = dataPointTooltipOption,
        exportToCsvOption = exportToCsvOption,
        exportWithHiddenFieldsOption = exportWithHiddenFieldsOption,
        sheetControlsOption = sheetControlsOption,
        sheetLayoutElementMaximizationOption = sheetLayoutElementMaximizationOption,
        visualAxisSortOption = visualAxisSortOption,
        visualMenuOption = visualMenuOption,
    )
}
