@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DashboardParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dateTimeParameters A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
 * @property decimalParameters A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
 * @property integerParameters A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
 * @property stringParameters A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
 */
public data class DashboardParametersArgs(
    public val dateTimeParameters: Output<List<DashboardParametersDateTimeParameterArgs>>? = null,
    public val decimalParameters: Output<List<DashboardParametersDecimalParameterArgs>>? = null,
    public val integerParameters: Output<List<DashboardParametersIntegerParameterArgs>>? = null,
    public val stringParameters: Output<List<DashboardParametersStringParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DashboardParametersArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DashboardParametersArgs =
        com.pulumi.aws.quicksight.inputs.DashboardParametersArgs.builder()
            .dateTimeParameters(
                dateTimeParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .decimalParameters(
                decimalParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .integerParameters(
                integerParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stringParameters(
                stringParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DashboardParametersArgs].
 */
@PulumiTagMarker
public class DashboardParametersArgsBuilder internal constructor() {
    private var dateTimeParameters: Output<List<DashboardParametersDateTimeParameterArgs>>? = null

    private var decimalParameters: Output<List<DashboardParametersDecimalParameterArgs>>? = null

    private var integerParameters: Output<List<DashboardParametersIntegerParameterArgs>>? = null

    private var stringParameters: Output<List<DashboardParametersStringParameterArgs>>? = null

    /**
     * @param value A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("iwdglbkfjkhiuwif")
    public suspend
    fun dateTimeParameters(`value`: Output<List<DashboardParametersDateTimeParameterArgs>>) {
        this.dateTimeParameters = value
    }

    @JvmName("emjsyhylpknixqmr")
    public suspend fun dateTimeParameters(
        vararg
        values: Output<DashboardParametersDateTimeParameterArgs>,
    ) {
        this.dateTimeParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("jaihfkcbuglggdor")
    public suspend
    fun dateTimeParameters(values: List<Output<DashboardParametersDateTimeParameterArgs>>) {
        this.dateTimeParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("lbivibfulqtnnefq")
    public suspend
    fun decimalParameters(`value`: Output<List<DashboardParametersDecimalParameterArgs>>) {
        this.decimalParameters = value
    }

    @JvmName("vpiodenrkhgpfkic")
    public suspend fun decimalParameters(
        vararg
        values: Output<DashboardParametersDecimalParameterArgs>,
    ) {
        this.decimalParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("blkihveuwieqssrg")
    public suspend
    fun decimalParameters(values: List<Output<DashboardParametersDecimalParameterArgs>>) {
        this.decimalParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("rulfjqxodhpwydyw")
    public suspend
    fun integerParameters(`value`: Output<List<DashboardParametersIntegerParameterArgs>>) {
        this.integerParameters = value
    }

    @JvmName("cijqlovskxjtieol")
    public suspend fun integerParameters(
        vararg
        values: Output<DashboardParametersIntegerParameterArgs>,
    ) {
        this.integerParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("yotkyfnmmsbsbcbe")
    public suspend
    fun integerParameters(values: List<Output<DashboardParametersIntegerParameterArgs>>) {
        this.integerParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("bydpsoaaypsxpwsh")
    public suspend
    fun stringParameters(`value`: Output<List<DashboardParametersStringParameterArgs>>) {
        this.stringParameters = value
    }

    @JvmName("ujlhvlarerpcjkos")
    public suspend fun stringParameters(
        vararg
        values: Output<DashboardParametersStringParameterArgs>,
    ) {
        this.stringParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("lpqepcvwjhaymbnf")
    public suspend
    fun stringParameters(values: List<Output<DashboardParametersStringParameterArgs>>) {
        this.stringParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("gltnaewvtgggsqgp")
    public suspend fun dateTimeParameters(`value`: List<DashboardParametersDateTimeParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateTimeParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("nbksqcvhdycqmvoe")
    public suspend
    fun dateTimeParameters(argument: List<suspend DashboardParametersDateTimeParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardParametersDateTimeParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dateTimeParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("vsqkhvwcsdvoywtx")
    public suspend fun dateTimeParameters(
        vararg
        argument: suspend DashboardParametersDateTimeParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DashboardParametersDateTimeParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dateTimeParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("yfqpyigrnlaqkwhr")
    public suspend
    fun dateTimeParameters(argument: suspend DashboardParametersDateTimeParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DashboardParametersDateTimeParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dateTimeParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("grgcdsgsispwuluc")
    public suspend fun dateTimeParameters(vararg values: DashboardParametersDateTimeParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dateTimeParameters = mapped
    }

    /**
     * @param value A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("ureaaybunmtelsbw")
    public suspend fun decimalParameters(`value`: List<DashboardParametersDecimalParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decimalParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("hottuwcschfeksqq")
    public suspend
    fun decimalParameters(argument: List<suspend DashboardParametersDecimalParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardParametersDecimalParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.decimalParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("pkaxpgwqpnixvbmn")
    public suspend fun decimalParameters(
        vararg
        argument: suspend DashboardParametersDecimalParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DashboardParametersDecimalParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.decimalParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("fbhbvgffhwbggste")
    public suspend
    fun decimalParameters(argument: suspend DashboardParametersDecimalParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DashboardParametersDecimalParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.decimalParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("nsltbuqptkbqpyde")
    public suspend fun decimalParameters(vararg values: DashboardParametersDecimalParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.decimalParameters = mapped
    }

    /**
     * @param value A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("qlknkqghbpajkfjh")
    public suspend fun integerParameters(`value`: List<DashboardParametersIntegerParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integerParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("miwyghuqhspcveng")
    public suspend
    fun integerParameters(argument: List<suspend DashboardParametersIntegerParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardParametersIntegerParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.integerParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("ghjcgtsmyjqsycma")
    public suspend fun integerParameters(
        vararg
        argument: suspend DashboardParametersIntegerParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DashboardParametersIntegerParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.integerParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("drkuvmkfaeicrxlm")
    public suspend
    fun integerParameters(argument: suspend DashboardParametersIntegerParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DashboardParametersIntegerParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.integerParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("ommdngksoibrjsmg")
    public suspend fun integerParameters(vararg values: DashboardParametersIntegerParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.integerParameters = mapped
    }

    /**
     * @param value A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("nidkxjomomboanak")
    public suspend fun stringParameters(`value`: List<DashboardParametersStringParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("dekdfeqwlrcbaqns")
    public suspend
    fun stringParameters(argument: List<suspend DashboardParametersStringParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardParametersStringParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("lklruwddckeeqrcj")
    public suspend fun stringParameters(
        vararg
        argument: suspend DashboardParametersStringParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DashboardParametersStringParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("svyfbxporarlrqak")
    public suspend
    fun stringParameters(argument: suspend DashboardParametersStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DashboardParametersStringParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.stringParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("mabweditcwafysfb")
    public suspend fun stringParameters(vararg values: DashboardParametersStringParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stringParameters = mapped
    }

    internal fun build(): DashboardParametersArgs = DashboardParametersArgs(
        dateTimeParameters = dateTimeParameters,
        decimalParameters = decimalParameters,
        integerParameters = integerParameters,
        stringParameters = stringParameters,
    )
}
