@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DashboardParametersDecimalParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Display name for the dashboard.
 * @property values
 */
public data class DashboardParametersDecimalParameterArgs(
    public val name: Output<String>,
    public val values: Output<List<Double>>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DashboardParametersDecimalParameterArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DashboardParametersDecimalParameterArgs =
        com.pulumi.aws.quicksight.inputs.DashboardParametersDecimalParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DashboardParametersDecimalParameterArgs].
 */
@PulumiTagMarker
public class DashboardParametersDecimalParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var values: Output<List<Double>>? = null

    /**
     * @param value Display name for the dashboard.
     */
    @JvmName("sfvexjxkupvbmmff")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("rfogcewrhaiscded")
    public suspend fun values(`value`: Output<List<Double>>) {
        this.values = value
    }

    @JvmName("tymkqpfnbgqtmkth")
    public suspend fun values(vararg values: Output<Double>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("aorieguubyqjphly")
    public suspend fun values(values: List<Output<Double>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Display name for the dashboard.
     */
    @JvmName("utimddickwbprleu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("hlcmworbgpfrtfve")
    public suspend fun values(`value`: List<Double>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("fmuaedqnwdwpewab")
    public suspend fun values(vararg values: Double) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): DashboardParametersDecimalParameterArgs =
        DashboardParametersDecimalParameterArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            values = values ?: throw PulumiNullFieldException("values"),
        )
}
