@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DashboardParametersStringParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Display name for the dashboard.
 * @property values
 */
public data class DashboardParametersStringParameterArgs(
    public val name: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DashboardParametersStringParameterArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DashboardParametersStringParameterArgs =
        com.pulumi.aws.quicksight.inputs.DashboardParametersStringParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DashboardParametersStringParameterArgs].
 */
@PulumiTagMarker
public class DashboardParametersStringParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Display name for the dashboard.
     */
    @JvmName("xkoaqdqucllhqmpd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("gxeolatsiivudbsr")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("wajcleuchutuglrn")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("dgoldadwcycdtfpr")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Display name for the dashboard.
     */
    @JvmName("rglhbcdycirltjfj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("lxdrwssrmtsirsgb")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("jfhsbvlgdbewrfcw")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): DashboardParametersStringParameterArgs =
        DashboardParametersStringParameterArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            values = values ?: throw PulumiNullFieldException("values"),
        )
}
