@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DashboardSourceEntitySourceTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the resource.
 * @property dataSetReferences List of dataset references. See data_set_references.
 */
public data class DashboardSourceEntitySourceTemplateArgs(
    public val arn: Output<String>,
    public val dataSetReferences:
    Output<List<DashboardSourceEntitySourceTemplateDataSetReferenceArgs>>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DashboardSourceEntitySourceTemplateArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DashboardSourceEntitySourceTemplateArgs =
        com.pulumi.aws.quicksight.inputs.DashboardSourceEntitySourceTemplateArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .dataSetReferences(
                dataSetReferences.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DashboardSourceEntitySourceTemplateArgs].
 */
@PulumiTagMarker
public class DashboardSourceEntitySourceTemplateArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var dataSetReferences:
        Output<List<DashboardSourceEntitySourceTemplateDataSetReferenceArgs>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the resource.
     */
    @JvmName("kjrrljrqbwpoaqmg")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value List of dataset references. See data_set_references.
     */
    @JvmName("qutcsustlfnjilxm")
    public suspend
    fun dataSetReferences(`value`: Output<List<DashboardSourceEntitySourceTemplateDataSetReferenceArgs>>) {
        this.dataSetReferences = value
    }

    @JvmName("xtmnbicbdqxjmeoa")
    public suspend fun dataSetReferences(
        vararg
        values: Output<DashboardSourceEntitySourceTemplateDataSetReferenceArgs>,
    ) {
        this.dataSetReferences = Output.all(values.asList())
    }

    /**
     * @param values List of dataset references. See data_set_references.
     */
    @JvmName("ppesbmdqiohvghtf")
    public suspend
    fun dataSetReferences(values: List<Output<DashboardSourceEntitySourceTemplateDataSetReferenceArgs>>) {
        this.dataSetReferences = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the resource.
     */
    @JvmName("vkrqjgueybkkjogn")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value List of dataset references. See data_set_references.
     */
    @JvmName("iftypuuvfjrssxhw")
    public suspend
    fun dataSetReferences(`value`: List<DashboardSourceEntitySourceTemplateDataSetReferenceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSetReferences = mapped
    }

    /**
     * @param argument List of dataset references. See data_set_references.
     */
    @JvmName("nynwhpegyjhoqpcq")
    public suspend
    fun dataSetReferences(argument: List<suspend DashboardSourceEntitySourceTemplateDataSetReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardSourceEntitySourceTemplateDataSetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataSetReferences = mapped
    }

    /**
     * @param argument List of dataset references. See data_set_references.
     */
    @JvmName("ysyigfnmwidusjxy")
    public suspend fun dataSetReferences(
        vararg
        argument: suspend DashboardSourceEntitySourceTemplateDataSetReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DashboardSourceEntitySourceTemplateDataSetReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataSetReferences = mapped
    }

    /**
     * @param argument List of dataset references. See data_set_references.
     */
    @JvmName("vbwifjqoxesdulfo")
    public suspend
    fun dataSetReferences(argument: suspend DashboardSourceEntitySourceTemplateDataSetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DashboardSourceEntitySourceTemplateDataSetReferenceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.dataSetReferences = mapped
    }

    /**
     * @param values List of dataset references. See data_set_references.
     */
    @JvmName("egmegcwdhxbgslwt")
    public suspend fun dataSetReferences(
        vararg
        values: DashboardSourceEntitySourceTemplateDataSetReferenceArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSetReferences = mapped
    }

    internal fun build(): DashboardSourceEntitySourceTemplateArgs =
        DashboardSourceEntitySourceTemplateArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            dataSetReferences = dataSetReferences ?: throw PulumiNullFieldException("dataSetReferences"),
        )
}
