@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DashboardSourceEntitySourceTemplateDataSetReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataSetArn Dataset Amazon Resource Name (ARN).
 * @property dataSetPlaceholder Dataset placeholder.
 */
public data class DashboardSourceEntitySourceTemplateDataSetReferenceArgs(
    public val dataSetArn: Output<String>,
    public val dataSetPlaceholder: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DashboardSourceEntitySourceTemplateDataSetReferenceArgs> {
    override fun toJava():
        com.pulumi.aws.quicksight.inputs.DashboardSourceEntitySourceTemplateDataSetReferenceArgs =
        com.pulumi.aws.quicksight.inputs.DashboardSourceEntitySourceTemplateDataSetReferenceArgs.builder()
            .dataSetArn(dataSetArn.applyValue({ args0 -> args0 }))
            .dataSetPlaceholder(dataSetPlaceholder.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DashboardSourceEntitySourceTemplateDataSetReferenceArgs].
 */
@PulumiTagMarker
public class DashboardSourceEntitySourceTemplateDataSetReferenceArgsBuilder internal constructor() {
    private var dataSetArn: Output<String>? = null

    private var dataSetPlaceholder: Output<String>? = null

    /**
     * @param value Dataset Amazon Resource Name (ARN).
     */
    @JvmName("njkpuyrwakooveue")
    public suspend fun dataSetArn(`value`: Output<String>) {
        this.dataSetArn = value
    }

    /**
     * @param value Dataset placeholder.
     */
    @JvmName("kcjjwpvhrjmdhdgt")
    public suspend fun dataSetPlaceholder(`value`: Output<String>) {
        this.dataSetPlaceholder = value
    }

    /**
     * @param value Dataset Amazon Resource Name (ARN).
     */
    @JvmName("dkuewhyteyuaysyx")
    public suspend fun dataSetArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSetArn = mapped
    }

    /**
     * @param value Dataset placeholder.
     */
    @JvmName("jsmusjrbwgebxdik")
    public suspend fun dataSetPlaceholder(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSetPlaceholder = mapped
    }

    internal fun build(): DashboardSourceEntitySourceTemplateDataSetReferenceArgs =
        DashboardSourceEntitySourceTemplateDataSetReferenceArgs(
            dataSetArn = dataSetArn ?: throw PulumiNullFieldException("dataSetArn"),
            dataSetPlaceholder = dataSetPlaceholder ?: throw PulumiNullFieldException("dataSetPlaceholder"),
        )
}
