@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetColumnGroupGeoSpatialColumnGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property columns Columns in this hierarchy.
 * @property countryCode Country code. Valid values are `US`.
 * @property name A display name for the hierarchy.
 */
public data class DataSetColumnGroupGeoSpatialColumnGroupArgs(
    public val columns: Output<List<String>>,
    public val countryCode: Output<String>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetColumnGroupGeoSpatialColumnGroupArgs> {
    override fun toJava():
        com.pulumi.aws.quicksight.inputs.DataSetColumnGroupGeoSpatialColumnGroupArgs =
        com.pulumi.aws.quicksight.inputs.DataSetColumnGroupGeoSpatialColumnGroupArgs.builder()
            .columns(columns.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .countryCode(countryCode.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetColumnGroupGeoSpatialColumnGroupArgs].
 */
@PulumiTagMarker
public class DataSetColumnGroupGeoSpatialColumnGroupArgsBuilder internal constructor() {
    private var columns: Output<List<String>>? = null

    private var countryCode: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Columns in this hierarchy.
     */
    @JvmName("qfqupeooujnvvypq")
    public suspend fun columns(`value`: Output<List<String>>) {
        this.columns = value
    }

    @JvmName("hlnfswyqkrymlytj")
    public suspend fun columns(vararg values: Output<String>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values Columns in this hierarchy.
     */
    @JvmName("rdrsouwvrmrvrbqj")
    public suspend fun columns(values: List<Output<String>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value Country code. Valid values are `US`.
     */
    @JvmName("bnormxvwgijiqeig")
    public suspend fun countryCode(`value`: Output<String>) {
        this.countryCode = value
    }

    /**
     * @param value A display name for the hierarchy.
     */
    @JvmName("mwsvposvewmkefyd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Columns in this hierarchy.
     */
    @JvmName("krultonymvkngcyv")
    public suspend fun columns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param values Columns in this hierarchy.
     */
    @JvmName("ihokqndlabgyoens")
    public suspend fun columns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value Country code. Valid values are `US`.
     */
    @JvmName("gapnrmpvhumkssfi")
    public suspend fun countryCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countryCode = mapped
    }

    /**
     * @param value A display name for the hierarchy.
     */
    @JvmName("gxkkeaaopojacpoi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): DataSetColumnGroupGeoSpatialColumnGroupArgs =
        DataSetColumnGroupGeoSpatialColumnGroupArgs(
            columns = columns ?: throw PulumiNullFieldException("columns"),
            countryCode = countryCode ?: throw PulumiNullFieldException("countryCode"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
