@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetColumnLevelPermissionRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property columnNames An array of column names.
 * @property principals An array of ARNs for Amazon QuickSight users or groups.
 */
public data class DataSetColumnLevelPermissionRuleArgs(
    public val columnNames: Output<List<String>>? = null,
    public val principals: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetColumnLevelPermissionRuleArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetColumnLevelPermissionRuleArgs =
        com.pulumi.aws.quicksight.inputs.DataSetColumnLevelPermissionRuleArgs.builder()
            .columnNames(columnNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .principals(principals?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DataSetColumnLevelPermissionRuleArgs].
 */
@PulumiTagMarker
public class DataSetColumnLevelPermissionRuleArgsBuilder internal constructor() {
    private var columnNames: Output<List<String>>? = null

    private var principals: Output<List<String>>? = null

    /**
     * @param value An array of column names.
     */
    @JvmName("gdgxfscxjqkxlccy")
    public suspend fun columnNames(`value`: Output<List<String>>) {
        this.columnNames = value
    }

    @JvmName("odrssjsgshxslfdf")
    public suspend fun columnNames(vararg values: Output<String>) {
        this.columnNames = Output.all(values.asList())
    }

    /**
     * @param values An array of column names.
     */
    @JvmName("yvleudafhggaamrf")
    public suspend fun columnNames(values: List<Output<String>>) {
        this.columnNames = Output.all(values)
    }

    /**
     * @param value An array of ARNs for Amazon QuickSight users or groups.
     */
    @JvmName("pekhcbkcfgoxvmtc")
    public suspend fun principals(`value`: Output<List<String>>) {
        this.principals = value
    }

    @JvmName("llxtgrohqvshgbtx")
    public suspend fun principals(vararg values: Output<String>) {
        this.principals = Output.all(values.asList())
    }

    /**
     * @param values An array of ARNs for Amazon QuickSight users or groups.
     */
    @JvmName("lsyikkmqdvyhyidm")
    public suspend fun principals(values: List<Output<String>>) {
        this.principals = Output.all(values)
    }

    /**
     * @param value An array of column names.
     */
    @JvmName("eaomdrgobkaeosom")
    public suspend fun columnNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnNames = mapped
    }

    /**
     * @param values An array of column names.
     */
    @JvmName("trmoqakiwkopcrbs")
    public suspend fun columnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnNames = mapped
    }

    /**
     * @param value An array of ARNs for Amazon QuickSight users or groups.
     */
    @JvmName("fywkbxmtxtdwurri")
    public suspend fun principals(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principals = mapped
    }

    /**
     * @param values An array of ARNs for Amazon QuickSight users or groups.
     */
    @JvmName("smmqmhfuowayovay")
    public suspend fun principals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principals = mapped
    }

    internal fun build(): DataSetColumnLevelPermissionRuleArgs = DataSetColumnLevelPermissionRuleArgs(
        columnNames = columnNames,
        principals = principals,
    )
}
