@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetFieldFolderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property columns An array of column names to add to the folder. A column can only be in one folder.
 * @property description Field folder description.
 * @property fieldFoldersId Key of the field folder map.
 */
public data class DataSetFieldFolderArgs(
    public val columns: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val fieldFoldersId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetFieldFolderArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetFieldFolderArgs =
        com.pulumi.aws.quicksight.inputs.DataSetFieldFolderArgs.builder()
            .columns(columns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fieldFoldersId(fieldFoldersId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetFieldFolderArgs].
 */
@PulumiTagMarker
public class DataSetFieldFolderArgsBuilder internal constructor() {
    private var columns: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var fieldFoldersId: Output<String>? = null

    /**
     * @param value An array of column names to add to the folder. A column can only be in one folder.
     */
    @JvmName("miiqjyrvkxebgqro")
    public suspend fun columns(`value`: Output<List<String>>) {
        this.columns = value
    }

    @JvmName("tdpmjqthybpqikro")
    public suspend fun columns(vararg values: Output<String>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values An array of column names to add to the folder. A column can only be in one folder.
     */
    @JvmName("oxdvnemjmweynrel")
    public suspend fun columns(values: List<Output<String>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value Field folder description.
     */
    @JvmName("uorndjyqahnotret")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Key of the field folder map.
     */
    @JvmName("nkksjroexsuaashx")
    public suspend fun fieldFoldersId(`value`: Output<String>) {
        this.fieldFoldersId = value
    }

    /**
     * @param value An array of column names to add to the folder. A column can only be in one folder.
     */
    @JvmName("mlsreuritdgpdnuq")
    public suspend fun columns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param values An array of column names to add to the folder. A column can only be in one folder.
     */
    @JvmName("idarjsrfqxapfwny")
    public suspend fun columns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value Field folder description.
     */
    @JvmName("vbxaxayfvxsqllxs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Key of the field folder map.
     */
    @JvmName("rotgxlchcvxhcscm")
    public suspend fun fieldFoldersId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldFoldersId = mapped
    }

    internal fun build(): DataSetFieldFolderArgs = DataSetFieldFolderArgs(
        columns = columns,
        description = description,
        fieldFoldersId = fieldFoldersId ?: throw PulumiNullFieldException("fieldFoldersId"),
    )
}
