@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property columnName Column name.
 * @property format When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.
 * @property newColumnType New column data type. Valid values are `STRING`, `INTEGER`, `DECIMAL`, `DATETIME`.
 */
public data class DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs(
    public val columnName: Output<String>,
    public val format: Output<String>? = null,
    public val newColumnType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs> {
    override fun toJava():
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs.builder()
            .columnName(columnName.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0 }))
            .newColumnType(newColumnType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgsBuilder internal
constructor() {
    private var columnName: Output<String>? = null

    private var format: Output<String>? = null

    private var newColumnType: Output<String>? = null

    /**
     * @param value Column name.
     */
    @JvmName("rrsnwwxdbssxcell")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.
     */
    @JvmName("wncfcoverfnoafmx")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value New column data type. Valid values are `STRING`, `INTEGER`, `DECIMAL`, `DATETIME`.
     */
    @JvmName("wqwhfxtovontqnqj")
    public suspend fun newColumnType(`value`: Output<String>) {
        this.newColumnType = value
    }

    /**
     * @param value Column name.
     */
    @JvmName("vtshoyrfligvwjna")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value When casting a column from string to datetime type, you can supply a string in a format supported by Amazon QuickSight to denote the source data format.
     */
    @JvmName("pylkxevtqjfjtaet")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value New column data type. Valid values are `STRING`, `INTEGER`, `DECIMAL`, `DATETIME`.
     */
    @JvmName("uanrgrluwamdevpf")
    public suspend fun newColumnType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.newColumnType = mapped
    }

    internal fun build(): DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs =
        DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs(
            columnName = columnName ?: throw PulumiNullFieldException("columnName"),
            format = format,
            newColumnType = newColumnType ?: throw PulumiNullFieldException("newColumnType"),
        )
}
