@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property columnId A unique ID to identify a calculated column. During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.
 * @property columnName Column name.
 * @property expression An expression that defines the calculated column.
 */
public data class DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs(
    public val columnId: Output<String>,
    public val columnName: Output<String>,
    public val expression: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs> {
    override fun toJava():
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs.builder()
            .columnId(columnId.applyValue({ args0 -> args0 }))
            .columnName(columnName.applyValue({ args0 -> args0 }))
            .expression(expression.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgsBuilder internal
constructor() {
    private var columnId: Output<String>? = null

    private var columnName: Output<String>? = null

    private var expression: Output<String>? = null

    /**
     * @param value A unique ID to identify a calculated column. During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.
     */
    @JvmName("jjsghiolgxfkyicp")
    public suspend fun columnId(`value`: Output<String>) {
        this.columnId = value
    }

    /**
     * @param value Column name.
     */
    @JvmName("bkjtekpvppfaewsx")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value An expression that defines the calculated column.
     */
    @JvmName("yuqtthgrdiatejdi")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value A unique ID to identify a calculated column. During a dataset update, if the column ID of a calculated column matches that of an existing calculated column, Amazon QuickSight preserves the existing calculated column.
     */
    @JvmName("cmathjqmksrdngvj")
    public suspend fun columnId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnId = mapped
    }

    /**
     * @param value Column name.
     */
    @JvmName("bgvdljfhyfbpgvaa")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value An expression that defines the calculated column.
     */
    @JvmName("nachdqimxaeojbqh")
    public suspend fun expression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    internal fun build(): DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs =
        DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs(
            columnId = columnId ?: throw PulumiNullFieldException("columnId"),
            columnName = columnName ?: throw PulumiNullFieldException("columnName"),
            expression = expression ?: throw PulumiNullFieldException("expression"),
        )
}
