@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dataSetArn ARN of the parent data set.
 * @property joinInstruction Specifies the result of a join of two logical tables. See join_instruction.
 * @property physicalTableId Physical table ID.
 */
public data class DataSetLogicalTableMapSourceArgs(
    public val dataSetArn: Output<String>? = null,
    public val joinInstruction: Output<DataSetLogicalTableMapSourceJoinInstructionArgs>? = null,
    public val physicalTableId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapSourceArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapSourceArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapSourceArgs.builder()
            .dataSetArn(dataSetArn?.applyValue({ args0 -> args0 }))
            .joinInstruction(joinInstruction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .physicalTableId(physicalTableId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetLogicalTableMapSourceArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapSourceArgsBuilder internal constructor() {
    private var dataSetArn: Output<String>? = null

    private var joinInstruction: Output<DataSetLogicalTableMapSourceJoinInstructionArgs>? = null

    private var physicalTableId: Output<String>? = null

    /**
     * @param value ARN of the parent data set.
     */
    @JvmName("shgrhifwrydktqpw")
    public suspend fun dataSetArn(`value`: Output<String>) {
        this.dataSetArn = value
    }

    /**
     * @param value Specifies the result of a join of two logical tables. See join_instruction.
     */
    @JvmName("vgdsvktqrhjutqba")
    public suspend
    fun joinInstruction(`value`: Output<DataSetLogicalTableMapSourceJoinInstructionArgs>) {
        this.joinInstruction = value
    }

    /**
     * @param value Physical table ID.
     */
    @JvmName("bfopyxcbpvhbhvdt")
    public suspend fun physicalTableId(`value`: Output<String>) {
        this.physicalTableId = value
    }

    /**
     * @param value ARN of the parent data set.
     */
    @JvmName("ikebrkmrtctxkcrv")
    public suspend fun dataSetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetArn = mapped
    }

    /**
     * @param value Specifies the result of a join of two logical tables. See join_instruction.
     */
    @JvmName("cspcfwfxbwqjwpho")
    public suspend fun joinInstruction(`value`: DataSetLogicalTableMapSourceJoinInstructionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.joinInstruction = mapped
    }

    /**
     * @param argument Specifies the result of a join of two logical tables. See join_instruction.
     */
    @JvmName("hclqdesksisjowpa")
    public suspend
    fun joinInstruction(argument: suspend DataSetLogicalTableMapSourceJoinInstructionArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetLogicalTableMapSourceJoinInstructionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.joinInstruction = mapped
    }

    /**
     * @param value Physical table ID.
     */
    @JvmName("xwceqcxrneahcrxe")
    public suspend fun physicalTableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.physicalTableId = mapped
    }

    internal fun build(): DataSetLogicalTableMapSourceArgs = DataSetLogicalTableMapSourceArgs(
        dataSetArn = dataSetArn,
        joinInstruction = joinInstruction,
        physicalTableId = physicalTableId,
    )
}
