@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapSourceJoinInstructionLeftJoinKeyPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property uniqueKey A value that indicates that a row in a table is uniquely identified by the columns in a join key. This is used by Amazon QuickSight to optimize query performance.
 */
public data class DataSetLogicalTableMapSourceJoinInstructionLeftJoinKeyPropertiesArgs(
    public val uniqueKey: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapSourceJoinInstructionLeftJoinKeyPropertiesArgs> {
    override fun toJava():
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapSourceJoinInstructionLeftJoinKeyPropertiesArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapSourceJoinInstructionLeftJoinKeyPropertiesArgs.builder()
            .uniqueKey(uniqueKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetLogicalTableMapSourceJoinInstructionLeftJoinKeyPropertiesArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapSourceJoinInstructionLeftJoinKeyPropertiesArgsBuilder internal
constructor() {
    private var uniqueKey: Output<Boolean>? = null

    /**
     * @param value A value that indicates that a row in a table is uniquely identified by the columns in a join key. This is used by Amazon QuickSight to optimize query performance.
     */
    @JvmName("khnmbnufqdwytmwj")
    public suspend fun uniqueKey(`value`: Output<Boolean>) {
        this.uniqueKey = value
    }

    /**
     * @param value A value that indicates that a row in a table is uniquely identified by the columns in a join key. This is used by Amazon QuickSight to optimize query performance.
     */
    @JvmName("wbyxqymdriiwehuv")
    public suspend fun uniqueKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueKey = mapped
    }

    internal fun build(): DataSetLogicalTableMapSourceJoinInstructionLeftJoinKeyPropertiesArgs =
        DataSetLogicalTableMapSourceJoinInstructionLeftJoinKeyPropertiesArgs(
            uniqueKey = uniqueKey,
        )
}
