@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customSql A physical table type built from the results of the custom SQL query. See custom_sql.
 * @property physicalTableMapId Key of the physical table map.
 * @property relationalTable A physical table type for relational data sources. See relational_table.
 * @property s3Source A physical table type for as S3 data source. See s3_source.
 */
public data class DataSetPhysicalTableMapArgs(
    public val customSql: Output<DataSetPhysicalTableMapCustomSqlArgs>? = null,
    public val physicalTableMapId: Output<String>,
    public val relationalTable: Output<DataSetPhysicalTableMapRelationalTableArgs>? = null,
    public val s3Source: Output<DataSetPhysicalTableMapS3SourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs =
        com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs.builder()
            .customSql(customSql?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .physicalTableMapId(physicalTableMapId.applyValue({ args0 -> args0 }))
            .relationalTable(relationalTable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3Source(s3Source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataSetPhysicalTableMapArgs].
 */
@PulumiTagMarker
public class DataSetPhysicalTableMapArgsBuilder internal constructor() {
    private var customSql: Output<DataSetPhysicalTableMapCustomSqlArgs>? = null

    private var physicalTableMapId: Output<String>? = null

    private var relationalTable: Output<DataSetPhysicalTableMapRelationalTableArgs>? = null

    private var s3Source: Output<DataSetPhysicalTableMapS3SourceArgs>? = null

    /**
     * @param value A physical table type built from the results of the custom SQL query. See custom_sql.
     */
    @JvmName("heuebxetsukxfdoa")
    public suspend fun customSql(`value`: Output<DataSetPhysicalTableMapCustomSqlArgs>) {
        this.customSql = value
    }

    /**
     * @param value Key of the physical table map.
     */
    @JvmName("gnqbcvcnoynurbwy")
    public suspend fun physicalTableMapId(`value`: Output<String>) {
        this.physicalTableMapId = value
    }

    /**
     * @param value A physical table type for relational data sources. See relational_table.
     */
    @JvmName("thukjviylrnyihuf")
    public suspend fun relationalTable(`value`: Output<DataSetPhysicalTableMapRelationalTableArgs>) {
        this.relationalTable = value
    }

    /**
     * @param value A physical table type for as S3 data source. See s3_source.
     */
    @JvmName("nvtvbionfwpdioeu")
    public suspend fun s3Source(`value`: Output<DataSetPhysicalTableMapS3SourceArgs>) {
        this.s3Source = value
    }

    /**
     * @param value A physical table type built from the results of the custom SQL query. See custom_sql.
     */
    @JvmName("dtciyssmumpfbnct")
    public suspend fun customSql(`value`: DataSetPhysicalTableMapCustomSqlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSql = mapped
    }

    /**
     * @param argument A physical table type built from the results of the custom SQL query. See custom_sql.
     */
    @JvmName("ylueyccmrouduvkn")
    public suspend
    fun customSql(argument: suspend DataSetPhysicalTableMapCustomSqlArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetPhysicalTableMapCustomSqlArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customSql = mapped
    }

    /**
     * @param value Key of the physical table map.
     */
    @JvmName("awnlvcunfapjvqeg")
    public suspend fun physicalTableMapId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.physicalTableMapId = mapped
    }

    /**
     * @param value A physical table type for relational data sources. See relational_table.
     */
    @JvmName("xpxxbrptngcyuuah")
    public suspend fun relationalTable(`value`: DataSetPhysicalTableMapRelationalTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationalTable = mapped
    }

    /**
     * @param argument A physical table type for relational data sources. See relational_table.
     */
    @JvmName("lwrwbnidimwatxym")
    public suspend
    fun relationalTable(argument: suspend DataSetPhysicalTableMapRelationalTableArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetPhysicalTableMapRelationalTableArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.relationalTable = mapped
    }

    /**
     * @param value A physical table type for as S3 data source. See s3_source.
     */
    @JvmName("gqncowkyychsnvnt")
    public suspend fun s3Source(`value`: DataSetPhysicalTableMapS3SourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Source = mapped
    }

    /**
     * @param argument A physical table type for as S3 data source. See s3_source.
     */
    @JvmName("lmrrnksffxwlfbsd")
    public suspend
    fun s3Source(argument: suspend DataSetPhysicalTableMapS3SourceArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetPhysicalTableMapS3SourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3Source = mapped
    }

    internal fun build(): DataSetPhysicalTableMapArgs = DataSetPhysicalTableMapArgs(
        customSql = customSql,
        physicalTableMapId = physicalTableMapId ?: throw PulumiNullFieldException("physicalTableMapId"),
        relationalTable = relationalTable,
        s3Source = s3Source,
    )
}
