@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapRelationalTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property catalog Catalog associated with the table.
 * @property dataSourceArn ARN of the data source.
 * @property inputColumns Column schema of the table. See input_columns.
 * @property name Name of the relational table.
 * @property schema Schema name. This name applies to certain relational database engines.
 */
public data class DataSetPhysicalTableMapRelationalTableArgs(
    public val catalog: Output<String>? = null,
    public val dataSourceArn: Output<String>,
    public val inputColumns: Output<List<DataSetPhysicalTableMapRelationalTableInputColumnArgs>>,
    public val name: Output<String>,
    public val schema: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapRelationalTableArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapRelationalTableArgs =
        com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapRelationalTableArgs.builder()
            .catalog(catalog?.applyValue({ args0 -> args0 }))
            .dataSourceArn(dataSourceArn.applyValue({ args0 -> args0 }))
            .inputColumns(
                inputColumns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetPhysicalTableMapRelationalTableArgs].
 */
@PulumiTagMarker
public class DataSetPhysicalTableMapRelationalTableArgsBuilder internal constructor() {
    private var catalog: Output<String>? = null

    private var dataSourceArn: Output<String>? = null

    private var inputColumns: Output<List<DataSetPhysicalTableMapRelationalTableInputColumnArgs>>? =
        null

    private var name: Output<String>? = null

    private var schema: Output<String>? = null

    /**
     * @param value Catalog associated with the table.
     */
    @JvmName("grlcekedtnufwwnu")
    public suspend fun catalog(`value`: Output<String>) {
        this.catalog = value
    }

    /**
     * @param value ARN of the data source.
     */
    @JvmName("wbpxxxcitsqmjsuu")
    public suspend fun dataSourceArn(`value`: Output<String>) {
        this.dataSourceArn = value
    }

    /**
     * @param value Column schema of the table. See input_columns.
     */
    @JvmName("voegmrprepuhqpnq")
    public suspend
    fun inputColumns(`value`: Output<List<DataSetPhysicalTableMapRelationalTableInputColumnArgs>>) {
        this.inputColumns = value
    }

    @JvmName("furjlpttygaeimuy")
    public suspend fun inputColumns(
        vararg
        values: Output<DataSetPhysicalTableMapRelationalTableInputColumnArgs>,
    ) {
        this.inputColumns = Output.all(values.asList())
    }

    /**
     * @param values Column schema of the table. See input_columns.
     */
    @JvmName("okwgrnxfaacuikog")
    public suspend
    fun inputColumns(values: List<Output<DataSetPhysicalTableMapRelationalTableInputColumnArgs>>) {
        this.inputColumns = Output.all(values)
    }

    /**
     * @param value Name of the relational table.
     */
    @JvmName("itfsxypdtunypgdf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Schema name. This name applies to certain relational database engines.
     */
    @JvmName("ockjomcgpbvhnknd")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value Catalog associated with the table.
     */
    @JvmName("knolvbctvukvmewc")
    public suspend fun catalog(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalog = mapped
    }

    /**
     * @param value ARN of the data source.
     */
    @JvmName("kuvpiaxenqxrnjtb")
    public suspend fun dataSourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSourceArn = mapped
    }

    /**
     * @param value Column schema of the table. See input_columns.
     */
    @JvmName("xkqbfalsfhojytso")
    public suspend
    fun inputColumns(`value`: List<DataSetPhysicalTableMapRelationalTableInputColumnArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputColumns = mapped
    }

    /**
     * @param argument Column schema of the table. See input_columns.
     */
    @JvmName("qjyubigfpnnebanx")
    public suspend
    fun inputColumns(argument: List<suspend DataSetPhysicalTableMapRelationalTableInputColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetPhysicalTableMapRelationalTableInputColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputColumns = mapped
    }

    /**
     * @param argument Column schema of the table. See input_columns.
     */
    @JvmName("eyvexqsyylknhnhw")
    public suspend fun inputColumns(
        vararg
        argument: suspend DataSetPhysicalTableMapRelationalTableInputColumnArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataSetPhysicalTableMapRelationalTableInputColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputColumns = mapped
    }

    /**
     * @param argument Column schema of the table. See input_columns.
     */
    @JvmName("djwnfwofwadchukx")
    public suspend
    fun inputColumns(argument: suspend DataSetPhysicalTableMapRelationalTableInputColumnArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DataSetPhysicalTableMapRelationalTableInputColumnArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.inputColumns = mapped
    }

    /**
     * @param values Column schema of the table. See input_columns.
     */
    @JvmName("fhpygwahuqkhgtgs")
    public suspend fun inputColumns(
        vararg
        values: DataSetPhysicalTableMapRelationalTableInputColumnArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputColumns = mapped
    }

    /**
     * @param value Name of the relational table.
     */
    @JvmName("nrmgstbkxnbrorvy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Schema name. This name applies to certain relational database engines.
     */
    @JvmName("wosfoawxanwvwlnm")
    public suspend fun schema(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    internal fun build(): DataSetPhysicalTableMapRelationalTableArgs =
        DataSetPhysicalTableMapRelationalTableArgs(
            catalog = catalog,
            dataSourceArn = dataSourceArn ?: throw PulumiNullFieldException("dataSourceArn"),
            inputColumns = inputColumns ?: throw PulumiNullFieldException("inputColumns"),
            name = name ?: throw PulumiNullFieldException("name"),
            schema = schema,
        )
}
