@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containsHeader Whether the file has a header row, or the files each have a header row.
 * @property delimiter Delimiter between values in the file.
 * @property format File format. Valid values are `CSV`, `TSV`, `CLF`, `ELF`, `XLSX`, and `JSON`.
 * @property startFromRow A row number to start reading data from.
 * @property textQualifier Text qualifier. Valid values are `DOUBLE_QUOTE` and `SINGLE_QUOTE`.
 */
public data class DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
    public val containsHeader: Output<Boolean>? = null,
    public val delimiter: Output<String>? = null,
    public val format: Output<String>? = null,
    public val startFromRow: Output<Int>? = null,
    public val textQualifier: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs =
        com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder()
            .containsHeader(containsHeader?.applyValue({ args0 -> args0 }))
            .delimiter(delimiter?.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0 }))
            .startFromRow(startFromRow?.applyValue({ args0 -> args0 }))
            .textQualifier(textQualifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetPhysicalTableMapS3SourceUploadSettingsArgs].
 */
@PulumiTagMarker
public class DataSetPhysicalTableMapS3SourceUploadSettingsArgsBuilder internal constructor() {
    private var containsHeader: Output<Boolean>? = null

    private var delimiter: Output<String>? = null

    private var format: Output<String>? = null

    private var startFromRow: Output<Int>? = null

    private var textQualifier: Output<String>? = null

    /**
     * @param value Whether the file has a header row, or the files each have a header row.
     */
    @JvmName("ajvgbirybbixexdy")
    public suspend fun containsHeader(`value`: Output<Boolean>) {
        this.containsHeader = value
    }

    /**
     * @param value Delimiter between values in the file.
     */
    @JvmName("qdleoxijhocqpsbq")
    public suspend fun delimiter(`value`: Output<String>) {
        this.delimiter = value
    }

    /**
     * @param value File format. Valid values are `CSV`, `TSV`, `CLF`, `ELF`, `XLSX`, and `JSON`.
     */
    @JvmName("vsmtvvyqnmgjyosx")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value A row number to start reading data from.
     */
    @JvmName("fbkkwvnadanxguly")
    public suspend fun startFromRow(`value`: Output<Int>) {
        this.startFromRow = value
    }

    /**
     * @param value Text qualifier. Valid values are `DOUBLE_QUOTE` and `SINGLE_QUOTE`.
     */
    @JvmName("tabsskbkgpabcidl")
    public suspend fun textQualifier(`value`: Output<String>) {
        this.textQualifier = value
    }

    /**
     * @param value Whether the file has a header row, or the files each have a header row.
     */
    @JvmName("jkioqvqubkdsscyi")
    public suspend fun containsHeader(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containsHeader = mapped
    }

    /**
     * @param value Delimiter between values in the file.
     */
    @JvmName("mnqtidbiogpayqmy")
    public suspend fun delimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delimiter = mapped
    }

    /**
     * @param value File format. Valid values are `CSV`, `TSV`, `CLF`, `ELF`, `XLSX`, and `JSON`.
     */
    @JvmName("cicdbvksusqgcteq")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value A row number to start reading data from.
     */
    @JvmName("wxeyavdblrorcqvw")
    public suspend fun startFromRow(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startFromRow = mapped
    }

    /**
     * @param value Text qualifier. Valid values are `DOUBLE_QUOTE` and `SINGLE_QUOTE`.
     */
    @JvmName("nqskbwrxceotrcev")
    public suspend fun textQualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.textQualifier = mapped
    }

    internal fun build(): DataSetPhysicalTableMapS3SourceUploadSettingsArgs =
        DataSetPhysicalTableMapS3SourceUploadSettingsArgs(
            containsHeader = containsHeader,
            delimiter = delimiter,
            format = format,
            startFromRow = startFromRow,
            textQualifier = textQualifier,
        )
}
