@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property incrementalRefresh The incremental refresh for the data set. See incremental_refresh.
 */
public data class DataSetRefreshPropertiesRefreshConfigurationArgs(
    public val incrementalRefresh:
    Output<DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationArgs =
        com.pulumi.aws.quicksight.inputs.DataSetRefreshPropertiesRefreshConfigurationArgs.builder()
            .incrementalRefresh(
                incrementalRefresh.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSetRefreshPropertiesRefreshConfigurationArgs].
 */
@PulumiTagMarker
public class DataSetRefreshPropertiesRefreshConfigurationArgsBuilder internal constructor() {
    private var incrementalRefresh:
        Output<DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs>? = null

    /**
     * @param value The incremental refresh for the data set. See incremental_refresh.
     */
    @JvmName("sxhcvnofdvoucauu")
    public suspend
    fun incrementalRefresh(`value`: Output<DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs>) {
        this.incrementalRefresh = value
    }

    /**
     * @param value The incremental refresh for the data set. See incremental_refresh.
     */
    @JvmName("juodreaijiwiwmvm")
    public suspend
    fun incrementalRefresh(`value`: DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.incrementalRefresh = mapped
    }

    /**
     * @param argument The incremental refresh for the data set. See incremental_refresh.
     */
    @JvmName("cijdqiwjscljknfi")
    public suspend
    fun incrementalRefresh(argument: suspend DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSetRefreshPropertiesRefreshConfigurationIncrementalRefreshArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.incrementalRefresh = mapped
    }

    internal fun build(): DataSetRefreshPropertiesRefreshConfigurationArgs =
        DataSetRefreshPropertiesRefreshConfigurationArgs(
            incrementalRefresh = incrementalRefresh ?: throw PulumiNullFieldException("incrementalRefresh"),
        )
}
