@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property amazonElasticsearch Parameters for connecting to Amazon Elasticsearch.
 * @property athena Parameters for connecting to Athena.
 * @property aurora Parameters for connecting to Aurora MySQL.
 * @property auroraPostgresql Parameters for connecting to Aurora Postgresql.
 * @property awsIotAnalytics Parameters for connecting to AWS IOT Analytics.
 * @property jira Parameters for connecting to Jira.
 * @property mariaDb Parameters for connecting to MariaDB.
 * @property mysql Parameters for connecting to MySQL.
 * @property oracle Parameters for connecting to Oracle.
 * @property postgresql Parameters for connecting to Postgresql.
 * @property presto Parameters for connecting to Presto.
 * @property rds Parameters for connecting to RDS.
 * @property redshift Parameters for connecting to Redshift.
 * @property s3 Parameters for connecting to S3.
 * @property serviceNow Parameters for connecting to ServiceNow.
 * @property snowflake Parameters for connecting to Snowflake.
 * @property spark Parameters for connecting to Spark.
 * @property sqlServer Parameters for connecting to SQL Server.
 * @property teradata Parameters for connecting to Teradata.
 * @property twitter Parameters for connecting to Twitter.
 */
public data class DataSourceParametersArgs(
    public val amazonElasticsearch: Output<DataSourceParametersAmazonElasticsearchArgs>? = null,
    public val athena: Output<DataSourceParametersAthenaArgs>? = null,
    public val aurora: Output<DataSourceParametersAuroraArgs>? = null,
    public val auroraPostgresql: Output<DataSourceParametersAuroraPostgresqlArgs>? = null,
    public val awsIotAnalytics: Output<DataSourceParametersAwsIotAnalyticsArgs>? = null,
    public val jira: Output<DataSourceParametersJiraArgs>? = null,
    public val mariaDb: Output<DataSourceParametersMariaDbArgs>? = null,
    public val mysql: Output<DataSourceParametersMysqlArgs>? = null,
    public val oracle: Output<DataSourceParametersOracleArgs>? = null,
    public val postgresql: Output<DataSourceParametersPostgresqlArgs>? = null,
    public val presto: Output<DataSourceParametersPrestoArgs>? = null,
    public val rds: Output<DataSourceParametersRdsArgs>? = null,
    public val redshift: Output<DataSourceParametersRedshiftArgs>? = null,
    public val s3: Output<DataSourceParametersS3Args>? = null,
    public val serviceNow: Output<DataSourceParametersServiceNowArgs>? = null,
    public val snowflake: Output<DataSourceParametersSnowflakeArgs>? = null,
    public val spark: Output<DataSourceParametersSparkArgs>? = null,
    public val sqlServer: Output<DataSourceParametersSqlServerArgs>? = null,
    public val teradata: Output<DataSourceParametersTeradataArgs>? = null,
    public val twitter: Output<DataSourceParametersTwitterArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersArgs.builder()
            .amazonElasticsearch(
                amazonElasticsearch?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .athena(athena?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .aurora(aurora?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .auroraPostgresql(auroraPostgresql?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .awsIotAnalytics(awsIotAnalytics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jira(jira?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mariaDb(mariaDb?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mysql(mysql?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .oracle(oracle?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .postgresql(postgresql?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presto(presto?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rds(rds?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .redshift(redshift?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3(s3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceNow(serviceNow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snowflake(snowflake?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .spark(spark?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sqlServer(sqlServer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .teradata(teradata?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .twitter(twitter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataSourceParametersArgs].
 */
@PulumiTagMarker
public class DataSourceParametersArgsBuilder internal constructor() {
    private var amazonElasticsearch: Output<DataSourceParametersAmazonElasticsearchArgs>? = null

    private var athena: Output<DataSourceParametersAthenaArgs>? = null

    private var aurora: Output<DataSourceParametersAuroraArgs>? = null

    private var auroraPostgresql: Output<DataSourceParametersAuroraPostgresqlArgs>? = null

    private var awsIotAnalytics: Output<DataSourceParametersAwsIotAnalyticsArgs>? = null

    private var jira: Output<DataSourceParametersJiraArgs>? = null

    private var mariaDb: Output<DataSourceParametersMariaDbArgs>? = null

    private var mysql: Output<DataSourceParametersMysqlArgs>? = null

    private var oracle: Output<DataSourceParametersOracleArgs>? = null

    private var postgresql: Output<DataSourceParametersPostgresqlArgs>? = null

    private var presto: Output<DataSourceParametersPrestoArgs>? = null

    private var rds: Output<DataSourceParametersRdsArgs>? = null

    private var redshift: Output<DataSourceParametersRedshiftArgs>? = null

    private var s3: Output<DataSourceParametersS3Args>? = null

    private var serviceNow: Output<DataSourceParametersServiceNowArgs>? = null

    private var snowflake: Output<DataSourceParametersSnowflakeArgs>? = null

    private var spark: Output<DataSourceParametersSparkArgs>? = null

    private var sqlServer: Output<DataSourceParametersSqlServerArgs>? = null

    private var teradata: Output<DataSourceParametersTeradataArgs>? = null

    private var twitter: Output<DataSourceParametersTwitterArgs>? = null

    /**
     * @param value Parameters for connecting to Amazon Elasticsearch.
     */
    @JvmName("metsninavlmdkqrr")
    public suspend
    fun amazonElasticsearch(`value`: Output<DataSourceParametersAmazonElasticsearchArgs>) {
        this.amazonElasticsearch = value
    }

    /**
     * @param value Parameters for connecting to Athena.
     */
    @JvmName("utmunujwvhvlqtpn")
    public suspend fun athena(`value`: Output<DataSourceParametersAthenaArgs>) {
        this.athena = value
    }

    /**
     * @param value Parameters for connecting to Aurora MySQL.
     */
    @JvmName("axaneaqfewyamkyj")
    public suspend fun aurora(`value`: Output<DataSourceParametersAuroraArgs>) {
        this.aurora = value
    }

    /**
     * @param value Parameters for connecting to Aurora Postgresql.
     */
    @JvmName("twblrrsrukxhyakc")
    public suspend fun auroraPostgresql(`value`: Output<DataSourceParametersAuroraPostgresqlArgs>) {
        this.auroraPostgresql = value
    }

    /**
     * @param value Parameters for connecting to AWS IOT Analytics.
     */
    @JvmName("anvsedoyutnsjtsk")
    public suspend fun awsIotAnalytics(`value`: Output<DataSourceParametersAwsIotAnalyticsArgs>) {
        this.awsIotAnalytics = value
    }

    /**
     * @param value Parameters for connecting to Jira.
     */
    @JvmName("jkkkegrtiwjnlpyt")
    public suspend fun jira(`value`: Output<DataSourceParametersJiraArgs>) {
        this.jira = value
    }

    /**
     * @param value Parameters for connecting to MariaDB.
     */
    @JvmName("hibyykeepgxixycg")
    public suspend fun mariaDb(`value`: Output<DataSourceParametersMariaDbArgs>) {
        this.mariaDb = value
    }

    /**
     * @param value Parameters for connecting to MySQL.
     */
    @JvmName("xdeuwrcpihttbvem")
    public suspend fun mysql(`value`: Output<DataSourceParametersMysqlArgs>) {
        this.mysql = value
    }

    /**
     * @param value Parameters for connecting to Oracle.
     */
    @JvmName("ordgrnbugqknnloa")
    public suspend fun oracle(`value`: Output<DataSourceParametersOracleArgs>) {
        this.oracle = value
    }

    /**
     * @param value Parameters for connecting to Postgresql.
     */
    @JvmName("vvvfefvmrfgyetld")
    public suspend fun postgresql(`value`: Output<DataSourceParametersPostgresqlArgs>) {
        this.postgresql = value
    }

    /**
     * @param value Parameters for connecting to Presto.
     */
    @JvmName("hahqtgjnwskchyde")
    public suspend fun presto(`value`: Output<DataSourceParametersPrestoArgs>) {
        this.presto = value
    }

    /**
     * @param value Parameters for connecting to RDS.
     */
    @JvmName("hsmhuamctvkdmbeh")
    public suspend fun rds(`value`: Output<DataSourceParametersRdsArgs>) {
        this.rds = value
    }

    /**
     * @param value Parameters for connecting to Redshift.
     */
    @JvmName("uebivkfpitbkfbya")
    public suspend fun redshift(`value`: Output<DataSourceParametersRedshiftArgs>) {
        this.redshift = value
    }

    /**
     * @param value Parameters for connecting to S3.
     */
    @JvmName("ibmjxreynenmyipn")
    public suspend fun s3(`value`: Output<DataSourceParametersS3Args>) {
        this.s3 = value
    }

    /**
     * @param value Parameters for connecting to ServiceNow.
     */
    @JvmName("guooogyerteusnxd")
    public suspend fun serviceNow(`value`: Output<DataSourceParametersServiceNowArgs>) {
        this.serviceNow = value
    }

    /**
     * @param value Parameters for connecting to Snowflake.
     */
    @JvmName("ywnxfdhxyralucsh")
    public suspend fun snowflake(`value`: Output<DataSourceParametersSnowflakeArgs>) {
        this.snowflake = value
    }

    /**
     * @param value Parameters for connecting to Spark.
     */
    @JvmName("qyvommulhrdkdguo")
    public suspend fun spark(`value`: Output<DataSourceParametersSparkArgs>) {
        this.spark = value
    }

    /**
     * @param value Parameters for connecting to SQL Server.
     */
    @JvmName("qablhqnamuxxesxo")
    public suspend fun sqlServer(`value`: Output<DataSourceParametersSqlServerArgs>) {
        this.sqlServer = value
    }

    /**
     * @param value Parameters for connecting to Teradata.
     */
    @JvmName("tegbycawhhqdidlf")
    public suspend fun teradata(`value`: Output<DataSourceParametersTeradataArgs>) {
        this.teradata = value
    }

    /**
     * @param value Parameters for connecting to Twitter.
     */
    @JvmName("wfjioxkenqthcfbd")
    public suspend fun twitter(`value`: Output<DataSourceParametersTwitterArgs>) {
        this.twitter = value
    }

    /**
     * @param value Parameters for connecting to Amazon Elasticsearch.
     */
    @JvmName("mkdbjnoxlrhgwxhs")
    public suspend fun amazonElasticsearch(`value`: DataSourceParametersAmazonElasticsearchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonElasticsearch = mapped
    }

    /**
     * @param argument Parameters for connecting to Amazon Elasticsearch.
     */
    @JvmName("rtoalbxondcukmme")
    public suspend
    fun amazonElasticsearch(argument: suspend DataSourceParametersAmazonElasticsearchArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersAmazonElasticsearchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.amazonElasticsearch = mapped
    }

    /**
     * @param value Parameters for connecting to Athena.
     */
    @JvmName("malbxqluhpdiqfxd")
    public suspend fun athena(`value`: DataSourceParametersAthenaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.athena = mapped
    }

    /**
     * @param argument Parameters for connecting to Athena.
     */
    @JvmName("pyhgvlmhuslvfede")
    public suspend fun athena(argument: suspend DataSourceParametersAthenaArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersAthenaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.athena = mapped
    }

    /**
     * @param value Parameters for connecting to Aurora MySQL.
     */
    @JvmName("ngpqasvfdappqced")
    public suspend fun aurora(`value`: DataSourceParametersAuroraArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aurora = mapped
    }

    /**
     * @param argument Parameters for connecting to Aurora MySQL.
     */
    @JvmName("spnrpnrtlyoiqspd")
    public suspend fun aurora(argument: suspend DataSourceParametersAuroraArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersAuroraArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aurora = mapped
    }

    /**
     * @param value Parameters for connecting to Aurora Postgresql.
     */
    @JvmName("fgvvejlboiptkogk")
    public suspend fun auroraPostgresql(`value`: DataSourceParametersAuroraPostgresqlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auroraPostgresql = mapped
    }

    /**
     * @param argument Parameters for connecting to Aurora Postgresql.
     */
    @JvmName("etforrmtacjvvdda")
    public suspend
    fun auroraPostgresql(argument: suspend DataSourceParametersAuroraPostgresqlArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersAuroraPostgresqlArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.auroraPostgresql = mapped
    }

    /**
     * @param value Parameters for connecting to AWS IOT Analytics.
     */
    @JvmName("usnupubgmabjuwdg")
    public suspend fun awsIotAnalytics(`value`: DataSourceParametersAwsIotAnalyticsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsIotAnalytics = mapped
    }

    /**
     * @param argument Parameters for connecting to AWS IOT Analytics.
     */
    @JvmName("wrmnfkiigwitewku")
    public suspend
    fun awsIotAnalytics(argument: suspend DataSourceParametersAwsIotAnalyticsArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersAwsIotAnalyticsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.awsIotAnalytics = mapped
    }

    /**
     * @param value Parameters for connecting to Jira.
     */
    @JvmName("nmwvtkidculacnhi")
    public suspend fun jira(`value`: DataSourceParametersJiraArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jira = mapped
    }

    /**
     * @param argument Parameters for connecting to Jira.
     */
    @JvmName("uxguyyvrwncearhh")
    public suspend fun jira(argument: suspend DataSourceParametersJiraArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersJiraArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.jira = mapped
    }

    /**
     * @param value Parameters for connecting to MariaDB.
     */
    @JvmName("wejhrbhxitttrqrk")
    public suspend fun mariaDb(`value`: DataSourceParametersMariaDbArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mariaDb = mapped
    }

    /**
     * @param argument Parameters for connecting to MariaDB.
     */
    @JvmName("slopmtnquheqfvme")
    public suspend fun mariaDb(argument: suspend DataSourceParametersMariaDbArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersMariaDbArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mariaDb = mapped
    }

    /**
     * @param value Parameters for connecting to MySQL.
     */
    @JvmName("oexwukgxxurqlbdw")
    public suspend fun mysql(`value`: DataSourceParametersMysqlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mysql = mapped
    }

    /**
     * @param argument Parameters for connecting to MySQL.
     */
    @JvmName("wetprcxnpovablko")
    public suspend fun mysql(argument: suspend DataSourceParametersMysqlArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersMysqlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mysql = mapped
    }

    /**
     * @param value Parameters for connecting to Oracle.
     */
    @JvmName("uobipthcodwiswew")
    public suspend fun oracle(`value`: DataSourceParametersOracleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oracle = mapped
    }

    /**
     * @param argument Parameters for connecting to Oracle.
     */
    @JvmName("clvkuqryoetwsijm")
    public suspend fun oracle(argument: suspend DataSourceParametersOracleArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersOracleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.oracle = mapped
    }

    /**
     * @param value Parameters for connecting to Postgresql.
     */
    @JvmName("qtthdvnsgskdfpts")
    public suspend fun postgresql(`value`: DataSourceParametersPostgresqlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postgresql = mapped
    }

    /**
     * @param argument Parameters for connecting to Postgresql.
     */
    @JvmName("nfkiflavamjfuiml")
    public suspend
    fun postgresql(argument: suspend DataSourceParametersPostgresqlArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersPostgresqlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.postgresql = mapped
    }

    /**
     * @param value Parameters for connecting to Presto.
     */
    @JvmName("gemjpeeaqgilbrki")
    public suspend fun presto(`value`: DataSourceParametersPrestoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presto = mapped
    }

    /**
     * @param argument Parameters for connecting to Presto.
     */
    @JvmName("voctyrtdiloajuiu")
    public suspend fun presto(argument: suspend DataSourceParametersPrestoArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersPrestoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presto = mapped
    }

    /**
     * @param value Parameters for connecting to RDS.
     */
    @JvmName("edixvnameoswygtx")
    public suspend fun rds(`value`: DataSourceParametersRdsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rds = mapped
    }

    /**
     * @param argument Parameters for connecting to RDS.
     */
    @JvmName("dumehsomgoyertwm")
    public suspend fun rds(argument: suspend DataSourceParametersRdsArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersRdsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rds = mapped
    }

    /**
     * @param value Parameters for connecting to Redshift.
     */
    @JvmName("clokqtkhohopaxpw")
    public suspend fun redshift(`value`: DataSourceParametersRedshiftArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshift = mapped
    }

    /**
     * @param argument Parameters for connecting to Redshift.
     */
    @JvmName("bfktujfclscajmmu")
    public suspend
    fun redshift(argument: suspend DataSourceParametersRedshiftArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersRedshiftArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redshift = mapped
    }

    /**
     * @param value Parameters for connecting to S3.
     */
    @JvmName("vhngahgpavhcuarx")
    public suspend fun s3(`value`: DataSourceParametersS3Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument Parameters for connecting to S3.
     */
    @JvmName("uemkvduuoeumxckb")
    public suspend fun s3(argument: suspend DataSourceParametersS3ArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersS3ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param value Parameters for connecting to ServiceNow.
     */
    @JvmName("gttlxehvqdnbsxsv")
    public suspend fun serviceNow(`value`: DataSourceParametersServiceNowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceNow = mapped
    }

    /**
     * @param argument Parameters for connecting to ServiceNow.
     */
    @JvmName("xyxpughtwfacecdt")
    public suspend
    fun serviceNow(argument: suspend DataSourceParametersServiceNowArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersServiceNowArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.serviceNow = mapped
    }

    /**
     * @param value Parameters for connecting to Snowflake.
     */
    @JvmName("mtgjyqxydkojkxih")
    public suspend fun snowflake(`value`: DataSourceParametersSnowflakeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snowflake = mapped
    }

    /**
     * @param argument Parameters for connecting to Snowflake.
     */
    @JvmName("mfbqdndghfocgiit")
    public suspend
    fun snowflake(argument: suspend DataSourceParametersSnowflakeArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersSnowflakeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.snowflake = mapped
    }

    /**
     * @param value Parameters for connecting to Spark.
     */
    @JvmName("gbgsdhxsbpbngywp")
    public suspend fun spark(`value`: DataSourceParametersSparkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spark = mapped
    }

    /**
     * @param argument Parameters for connecting to Spark.
     */
    @JvmName("povujhhkhqxfnryn")
    public suspend fun spark(argument: suspend DataSourceParametersSparkArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersSparkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spark = mapped
    }

    /**
     * @param value Parameters for connecting to SQL Server.
     */
    @JvmName("exbadjwxxrvpkfgp")
    public suspend fun sqlServer(`value`: DataSourceParametersSqlServerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServer = mapped
    }

    /**
     * @param argument Parameters for connecting to SQL Server.
     */
    @JvmName("foecdndrtycpdgiu")
    public suspend
    fun sqlServer(argument: suspend DataSourceParametersSqlServerArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersSqlServerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sqlServer = mapped
    }

    /**
     * @param value Parameters for connecting to Teradata.
     */
    @JvmName("rxxakwlilunaumia")
    public suspend fun teradata(`value`: DataSourceParametersTeradataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teradata = mapped
    }

    /**
     * @param argument Parameters for connecting to Teradata.
     */
    @JvmName("cmegavvfeoadngnr")
    public suspend
    fun teradata(argument: suspend DataSourceParametersTeradataArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersTeradataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.teradata = mapped
    }

    /**
     * @param value Parameters for connecting to Twitter.
     */
    @JvmName("wnluaauibwcxcuib")
    public suspend fun twitter(`value`: DataSourceParametersTwitterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.twitter = mapped
    }

    /**
     * @param argument Parameters for connecting to Twitter.
     */
    @JvmName("alxqtyoymnwkebgc")
    public suspend fun twitter(argument: suspend DataSourceParametersTwitterArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersTwitterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.twitter = mapped
    }

    internal fun build(): DataSourceParametersArgs = DataSourceParametersArgs(
        amazonElasticsearch = amazonElasticsearch,
        athena = athena,
        aurora = aurora,
        auroraPostgresql = auroraPostgresql,
        awsIotAnalytics = awsIotAnalytics,
        jira = jira,
        mariaDb = mariaDb,
        mysql = mysql,
        oracle = oracle,
        postgresql = postgresql,
        presto = presto,
        rds = rds,
        redshift = redshift,
        s3 = s3,
        serviceNow = serviceNow,
        snowflake = snowflake,
        spark = spark,
        sqlServer = sqlServer,
        teradata = teradata,
        twitter = twitter,
    )
}
