@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersAuroraPostgresqlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property database The database to which to connect.
 * @property host The host to which to connect.
 * @property port The port to which to connect.
 */
public data class DataSourceParametersAuroraPostgresqlArgs(
    public val database: Output<String>,
    public val host: Output<String>,
    public val port: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersAuroraPostgresqlArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersAuroraPostgresqlArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersAuroraPostgresqlArgs.builder()
            .database(database.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersAuroraPostgresqlArgs].
 */
@PulumiTagMarker
public class DataSourceParametersAuroraPostgresqlArgsBuilder internal constructor() {
    private var database: Output<String>? = null

    private var host: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The database to which to connect.
     */
    @JvmName("oclqbvstiuixuxgi")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The host to which to connect.
     */
    @JvmName("smwexqakcjdyhwud")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The port to which to connect.
     */
    @JvmName("nteutlgxxpmjrqma")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The database to which to connect.
     */
    @JvmName("joockpshgdkrupjb")
    public suspend fun database(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The host to which to connect.
     */
    @JvmName("qfechugnituidqcw")
    public suspend fun host(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The port to which to connect.
     */
    @JvmName("luikinapspxqtkdx")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): DataSourceParametersAuroraPostgresqlArgs =
        DataSourceParametersAuroraPostgresqlArgs(
            database = database ?: throw PulumiNullFieldException("database"),
            host = host ?: throw PulumiNullFieldException("host"),
            port = port ?: throw PulumiNullFieldException("port"),
        )
}
