@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersAwsIotAnalyticsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataSetName The name of the data set to which to connect.
 */
public data class DataSourceParametersAwsIotAnalyticsArgs(
    public val dataSetName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersAwsIotAnalyticsArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersAwsIotAnalyticsArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersAwsIotAnalyticsArgs.builder()
            .dataSetName(dataSetName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersAwsIotAnalyticsArgs].
 */
@PulumiTagMarker
public class DataSourceParametersAwsIotAnalyticsArgsBuilder internal constructor() {
    private var dataSetName: Output<String>? = null

    /**
     * @param value The name of the data set to which to connect.
     */
    @JvmName("uijlwqewhyfmuqbr")
    public suspend fun dataSetName(`value`: Output<String>) {
        this.dataSetName = value
    }

    /**
     * @param value The name of the data set to which to connect.
     */
    @JvmName("wkcqareytlvwnrtp")
    public suspend fun dataSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSetName = mapped
    }

    internal fun build(): DataSourceParametersAwsIotAnalyticsArgs =
        DataSourceParametersAwsIotAnalyticsArgs(
            dataSetName = dataSetName ?: throw PulumiNullFieldException("dataSetName"),
        )
}
