@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersPrestoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalog The catalog to which to connect.
 * @property host The host to which to connect.
 * @property port The port to which to connect.
 */
public data class DataSourceParametersPrestoArgs(
    public val catalog: Output<String>,
    public val host: Output<String>,
    public val port: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersPrestoArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersPrestoArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersPrestoArgs.builder()
            .catalog(catalog.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersPrestoArgs].
 */
@PulumiTagMarker
public class DataSourceParametersPrestoArgsBuilder internal constructor() {
    private var catalog: Output<String>? = null

    private var host: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The catalog to which to connect.
     */
    @JvmName("sxeoncmmavguiiid")
    public suspend fun catalog(`value`: Output<String>) {
        this.catalog = value
    }

    /**
     * @param value The host to which to connect.
     */
    @JvmName("kjrmllobxjiiveoo")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The port to which to connect.
     */
    @JvmName("ybvfgsgqlejpcvcm")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The catalog to which to connect.
     */
    @JvmName("ufaxxryhvhkfxreg")
    public suspend fun catalog(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalog = mapped
    }

    /**
     * @param value The host to which to connect.
     */
    @JvmName("kneocviygetitjxg")
    public suspend fun host(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The port to which to connect.
     */
    @JvmName("yrokoxdgrdxxrklk")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): DataSourceParametersPrestoArgs = DataSourceParametersPrestoArgs(
        catalog = catalog ?: throw PulumiNullFieldException("catalog"),
        host = host ?: throw PulumiNullFieldException("host"),
        port = port ?: throw PulumiNullFieldException("port"),
    )
}
