@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersS3ManifestFileLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket The name of the bucket that contains the manifest file.
 * @property key The key of the manifest file within the bucket.
 */
public data class DataSourceParametersS3ManifestFileLocationArgs(
    public val bucket: Output<String>,
    public val key: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersS3ManifestFileLocationArgs> {
    override fun toJava():
        com.pulumi.aws.quicksight.inputs.DataSourceParametersS3ManifestFileLocationArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersS3ManifestFileLocationArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersS3ManifestFileLocationArgs].
 */
@PulumiTagMarker
public class DataSourceParametersS3ManifestFileLocationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var key: Output<String>? = null

    /**
     * @param value The name of the bucket that contains the manifest file.
     */
    @JvmName("dslhprbkpvixeqkm")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The key of the manifest file within the bucket.
     */
    @JvmName("hxcbasqrnxatrdtg")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The name of the bucket that contains the manifest file.
     */
    @JvmName("lmedsuetyiyuaocg")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The key of the manifest file within the bucket.
     */
    @JvmName("lulkvroijhbgseah")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): DataSourceParametersS3ManifestFileLocationArgs =
        DataSourceParametersS3ManifestFileLocationArgs(
            bucket = bucket ?: throw PulumiNullFieldException("bucket"),
            key = key ?: throw PulumiNullFieldException("key"),
        )
}
