@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersServiceNowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property siteBaseUrl The base URL of the Jira instance's site to which to connect.
 */
public data class DataSourceParametersServiceNowArgs(
    public val siteBaseUrl: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersServiceNowArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersServiceNowArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersServiceNowArgs.builder()
            .siteBaseUrl(siteBaseUrl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersServiceNowArgs].
 */
@PulumiTagMarker
public class DataSourceParametersServiceNowArgsBuilder internal constructor() {
    private var siteBaseUrl: Output<String>? = null

    /**
     * @param value The base URL of the Jira instance's site to which to connect.
     */
    @JvmName("iaertmtndbkmfemk")
    public suspend fun siteBaseUrl(`value`: Output<String>) {
        this.siteBaseUrl = value
    }

    /**
     * @param value The base URL of the Jira instance's site to which to connect.
     */
    @JvmName("jaqcketwiayjiojj")
    public suspend fun siteBaseUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.siteBaseUrl = mapped
    }

    internal fun build(): DataSourceParametersServiceNowArgs = DataSourceParametersServiceNowArgs(
        siteBaseUrl = siteBaseUrl ?: throw PulumiNullFieldException("siteBaseUrl"),
    )
}
