@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersSnowflakeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property database The database to which to connect.
 * @property host The host to which to connect.
 * @property warehouse The warehouse to which to connect.
 */
public data class DataSourceParametersSnowflakeArgs(
    public val database: Output<String>,
    public val host: Output<String>,
    public val warehouse: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersSnowflakeArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersSnowflakeArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersSnowflakeArgs.builder()
            .database(database.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .warehouse(warehouse.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersSnowflakeArgs].
 */
@PulumiTagMarker
public class DataSourceParametersSnowflakeArgsBuilder internal constructor() {
    private var database: Output<String>? = null

    private var host: Output<String>? = null

    private var warehouse: Output<String>? = null

    /**
     * @param value The database to which to connect.
     */
    @JvmName("ngtowrkdaoqorqmy")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The host to which to connect.
     */
    @JvmName("djdcwjntsgweaqcl")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The warehouse to which to connect.
     */
    @JvmName("rurdkeeciybolgxc")
    public suspend fun warehouse(`value`: Output<String>) {
        this.warehouse = value
    }

    /**
     * @param value The database to which to connect.
     */
    @JvmName("roqibmxoykvxaxwd")
    public suspend fun database(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The host to which to connect.
     */
    @JvmName("cgqkwlgxbbmavcgn")
    public suspend fun host(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The warehouse to which to connect.
     */
    @JvmName("prcdaswyxqluyspy")
    public suspend fun warehouse(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.warehouse = mapped
    }

    internal fun build(): DataSourceParametersSnowflakeArgs = DataSourceParametersSnowflakeArgs(
        database = database ?: throw PulumiNullFieldException("database"),
        host = host ?: throw PulumiNullFieldException("host"),
        warehouse = warehouse ?: throw PulumiNullFieldException("warehouse"),
    )
}
