@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceParametersSqlServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property database The database to which to connect.
 * @property host The host to which to connect.
 * @property port The warehouse to which to connect.
 */
public data class DataSourceParametersSqlServerArgs(
    public val database: Output<String>,
    public val host: Output<String>,
    public val port: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceParametersSqlServerArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceParametersSqlServerArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceParametersSqlServerArgs.builder()
            .database(database.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceParametersSqlServerArgs].
 */
@PulumiTagMarker
public class DataSourceParametersSqlServerArgsBuilder internal constructor() {
    private var database: Output<String>? = null

    private var host: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value The database to which to connect.
     */
    @JvmName("mcxhhdesqkymtdrk")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The host to which to connect.
     */
    @JvmName("gnavewnbejprnumn")
    public suspend fun host(`value`: Output<String>) {
        this.host = value
    }

    /**
     * @param value The warehouse to which to connect.
     */
    @JvmName("jeawcktnuvvruolm")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The database to which to connect.
     */
    @JvmName("jtprojpwhdlxgyiq")
    public suspend fun database(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The host to which to connect.
     */
    @JvmName("pwqjgrswtjixnfjl")
    public suspend fun host(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The warehouse to which to connect.
     */
    @JvmName("wibqbguosogfpblw")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): DataSourceParametersSqlServerArgs = DataSourceParametersSqlServerArgs(
        database = database ?: throw PulumiNullFieldException("database"),
        host = host ?: throw PulumiNullFieldException("host"),
        port = port ?: throw PulumiNullFieldException("port"),
    )
}
