@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourcePermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property actions Set of IAM actions to grant or revoke permissions on. Max of 16 items.
 * @property principal The Amazon Resource Name (ARN) of the principal.
 */
public data class DataSourcePermissionArgs(
    public val actions: Output<List<String>>,
    public val principal: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourcePermissionArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourcePermissionArgs =
        com.pulumi.aws.quicksight.inputs.DataSourcePermissionArgs.builder()
            .actions(actions.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .principal(principal.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourcePermissionArgs].
 */
@PulumiTagMarker
public class DataSourcePermissionArgsBuilder internal constructor() {
    private var actions: Output<List<String>>? = null

    private var principal: Output<String>? = null

    /**
     * @param value Set of IAM actions to grant or revoke permissions on. Max of 16 items.
     */
    @JvmName("milmeawgdlhjwxap")
    public suspend fun actions(`value`: Output<List<String>>) {
        this.actions = value
    }

    @JvmName("bdtbjmrhbshuaajr")
    public suspend fun actions(vararg values: Output<String>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values Set of IAM actions to grant or revoke permissions on. Max of 16 items.
     */
    @JvmName("wunqfbejbnghacng")
    public suspend fun actions(values: List<Output<String>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the principal.
     */
    @JvmName("crkrtpnvqcvfdplr")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value Set of IAM actions to grant or revoke permissions on. Max of 16 items.
     */
    @JvmName("mxrjakhttypwngmm")
    public suspend fun actions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values Set of IAM actions to grant or revoke permissions on. Max of 16 items.
     */
    @JvmName("exhcdiophmctlncn")
    public suspend fun actions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the principal.
     */
    @JvmName("wfvojlpolnjmrkpe")
    public suspend fun principal(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    internal fun build(): DataSourcePermissionArgs = DataSourcePermissionArgs(
        actions = actions ?: throw PulumiNullFieldException("actions"),
        principal = principal ?: throw PulumiNullFieldException("principal"),
    )
}
