@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSourceSslPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property disableSsl A Boolean option to control whether SSL should be disabled.
 */
public data class DataSourceSslPropertiesArgs(
    public val disableSsl: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSourceSslPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSourceSslPropertiesArgs =
        com.pulumi.aws.quicksight.inputs.DataSourceSslPropertiesArgs.builder()
            .disableSsl(disableSsl.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSourceSslPropertiesArgs].
 */
@PulumiTagMarker
public class DataSourceSslPropertiesArgsBuilder internal constructor() {
    private var disableSsl: Output<Boolean>? = null

    /**
     * @param value A Boolean option to control whether SSL should be disabled.
     */
    @JvmName("tsnisyttgaemvkav")
    public suspend fun disableSsl(`value`: Output<Boolean>) {
        this.disableSsl = value
    }

    /**
     * @param value A Boolean option to control whether SSL should be disabled.
     */
    @JvmName("lgueuachoeycfusr")
    public suspend fun disableSsl(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disableSsl = mapped
    }

    internal fun build(): DataSourceSslPropertiesArgs = DataSourceSslPropertiesArgs(
        disableSsl = disableSsl ?: throw PulumiNullFieldException("disableSsl"),
    )
}
