@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.GetDataSetColumnLevelPermissionRule.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property columnNames
 * @property principals
 */
public data class GetDataSetColumnLevelPermissionRule(
    public val columnNames: List<String>,
    public val principals: List<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.GetDataSetColumnLevelPermissionRule> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.GetDataSetColumnLevelPermissionRule =
        com.pulumi.aws.quicksight.inputs.GetDataSetColumnLevelPermissionRule.builder()
            .columnNames(columnNames.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .principals(principals.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetDataSetColumnLevelPermissionRule].
 */
@PulumiTagMarker
public class GetDataSetColumnLevelPermissionRuleBuilder internal constructor() {
    private var columnNames: List<String>? = null

    private var principals: List<String>? = null

    /**
     * @param value
     */
    @JvmName("dsassvygxovqpyst")
    public suspend fun columnNames(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.columnNames = mapped
    }

    /**
     * @param values
     */
    @JvmName("sbcsmdomakkkwhfb")
    public suspend fun columnNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.columnNames = mapped
    }

    /**
     * @param value
     */
    @JvmName("mctteyoypejqccfq")
    public suspend fun principals(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principals = mapped
    }

    /**
     * @param values
     */
    @JvmName("vtngodbqjiudlsdy")
    public suspend fun principals(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principals = mapped
    }

    internal fun build(): GetDataSetColumnLevelPermissionRule = GetDataSetColumnLevelPermissionRule(
        columnNames = columnNames ?: throw PulumiNullFieldException("columnNames"),
        principals = principals ?: throw PulumiNullFieldException("principals"),
    )
}
