@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.GetDataSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDataSet.
 * @property awsAccountId AWS account ID.
 * @property columnLevelPermissionRules
 * @property dataSetId Identifier for the data set.
 * The following arguments are optional:
 * @property tags
 * @property tagsAll
 */
public data class GetDataSetPlainArgs(
    public val awsAccountId: String? = null,
    public val columnLevelPermissionRules: List<GetDataSetColumnLevelPermissionRule>? = null,
    public val dataSetId: String,
    public val tags: Map<String, String>? = null,
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    public val tagsAll: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.GetDataSetPlainArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.GetDataSetPlainArgs =
        com.pulumi.aws.quicksight.inputs.GetDataSetPlainArgs.builder()
            .awsAccountId(awsAccountId?.let({ args0 -> args0 }))
            .columnLevelPermissionRules(
                columnLevelPermissionRules?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dataSetId(dataSetId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tagsAll(tagsAll?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDataSetPlainArgs].
 */
@PulumiTagMarker
public class GetDataSetPlainArgsBuilder internal constructor() {
    private var awsAccountId: String? = null

    private var columnLevelPermissionRules: List<GetDataSetColumnLevelPermissionRule>? = null

    private var dataSetId: String? = null

    private var tags: Map<String, String>? = null

    private var tagsAll: Map<String, String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("lmywaaxtsvowthlo")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.awsAccountId = mapped
    }

    /**
     * @param value
     */
    @JvmName("rogyuuklxugnjihx")
    public suspend
    fun columnLevelPermissionRules(`value`: List<GetDataSetColumnLevelPermissionRule>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.columnLevelPermissionRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("isshjqhvbnebhysk")
    public suspend
    fun columnLevelPermissionRules(argument: List<suspend GetDataSetColumnLevelPermissionRuleBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetDataSetColumnLevelPermissionRuleBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.columnLevelPermissionRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("krbxpsmsgkykwvwl")
    public suspend fun columnLevelPermissionRules(
        vararg
        argument: suspend GetDataSetColumnLevelPermissionRuleBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetDataSetColumnLevelPermissionRuleBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.columnLevelPermissionRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ftrilylrqqliwdni")
    public suspend
    fun columnLevelPermissionRules(argument: suspend GetDataSetColumnLevelPermissionRuleBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetDataSetColumnLevelPermissionRuleBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.columnLevelPermissionRules = mapped
    }

    /**
     * @param values
     */
    @JvmName("quxdcefhksgsgeae")
    public suspend fun columnLevelPermissionRules(
        vararg
        values: GetDataSetColumnLevelPermissionRule,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.columnLevelPermissionRules = mapped
    }

    /**
     * @param value Identifier for the data set.
     * The following arguments are optional:
     */
    @JvmName("ownsnnofwprfbukr")
    public suspend fun dataSetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataSetId = mapped
    }

    /**
     * @param value
     */
    @JvmName("uwrtatvflrywaqub")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("fwwjhqomojgemvey")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    @JvmName("pnsvckomnvownicl")
    public suspend fun tagsAll(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tagsAll = mapped
    }

    /**
     * @param values
     */
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    @JvmName("koimseqtbcqrxulk")
    public fun tagsAll(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagsAll = mapped
    }

    internal fun build(): GetDataSetPlainArgs = GetDataSetPlainArgs(
        awsAccountId = awsAccountId,
        columnLevelPermissionRules = columnLevelPermissionRules,
        dataSetId = dataSetId ?: throw PulumiNullFieldException("dataSetId"),
        tags = tags,
        tagsAll = tagsAll,
    )
}
