@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.GetQuicksightGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQuicksightGroup.
 * @property awsAccountId AWS account ID.
 * @property groupName The name of the group that you want to match.
 * The following arguments are optional:
 * @property namespace QuickSight namespace. Defaults to `default`.
 */
public data class GetQuicksightGroupPlainArgs(
    public val awsAccountId: String? = null,
    public val groupName: String,
    public val namespace: String? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.GetQuicksightGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.GetQuicksightGroupPlainArgs =
        com.pulumi.aws.quicksight.inputs.GetQuicksightGroupPlainArgs.builder()
            .awsAccountId(awsAccountId?.let({ args0 -> args0 }))
            .groupName(groupName.let({ args0 -> args0 }))
            .namespace(namespace?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetQuicksightGroupPlainArgs].
 */
@PulumiTagMarker
public class GetQuicksightGroupPlainArgsBuilder internal constructor() {
    private var awsAccountId: String? = null

    private var groupName: String? = null

    private var namespace: String? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("cpclfdmsmrglckcr")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.awsAccountId = mapped
    }

    /**
     * @param value The name of the group that you want to match.
     * The following arguments are optional:
     */
    @JvmName("yjgralotivhiqurr")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value QuickSight namespace. Defaults to `default`.
     */
    @JvmName("yniradpsfmeyjogf")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namespace = mapped
    }

    internal fun build(): GetQuicksightGroupPlainArgs = GetQuicksightGroupPlainArgs(
        awsAccountId = awsAccountId,
        groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        namespace = namespace,
    )
}
