@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.GetThemePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTheme.
 * @property awsAccountId AWS account ID.
 * @property tags A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
 * @property themeId Identifier of the theme.
 * The following arguments are optional:
 */
public data class GetThemePlainArgs(
    public val awsAccountId: String? = null,
    public val tags: Map<String, String>? = null,
    public val themeId: String,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.GetThemePlainArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.GetThemePlainArgs =
        com.pulumi.aws.quicksight.inputs.GetThemePlainArgs.builder()
            .awsAccountId(awsAccountId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .themeId(themeId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetThemePlainArgs].
 */
@PulumiTagMarker
public class GetThemePlainArgsBuilder internal constructor() {
    private var awsAccountId: String? = null

    private var tags: Map<String, String>? = null

    private var themeId: String? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("wcrpgvcnngunkhht")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.awsAccountId = mapped
    }

    /**
     * @param value A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @JvmName("gvixccgtcfdjoaaq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @JvmName("ojditfbufqkwpann")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Identifier of the theme.
     * The following arguments are optional:
     */
    @JvmName("iyerglxqcrxdqjdk")
    public suspend fun themeId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.themeId = mapped
    }

    internal fun build(): GetThemePlainArgs = GetThemePlainArgs(
        awsAccountId = awsAccountId,
        tags = tags,
        themeId = themeId ?: throw PulumiNullFieldException("themeId"),
    )
}
