@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.IamPolicyAssignmentIdentitiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property groups
 * @property users Array of Quicksight user names to assign the policy to.
 */
public data class IamPolicyAssignmentIdentitiesArgs(
    public val groups: Output<List<String>>? = null,
    public val users: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.IamPolicyAssignmentIdentitiesArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.IamPolicyAssignmentIdentitiesArgs =
        com.pulumi.aws.quicksight.inputs.IamPolicyAssignmentIdentitiesArgs.builder()
            .groups(groups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .users(users?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [IamPolicyAssignmentIdentitiesArgs].
 */
@PulumiTagMarker
public class IamPolicyAssignmentIdentitiesArgsBuilder internal constructor() {
    private var groups: Output<List<String>>? = null

    private var users: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("surkpebicxqcmyet")
    public suspend fun groups(`value`: Output<List<String>>) {
        this.groups = value
    }

    @JvmName("hrdeteeerbttgtrf")
    public suspend fun groups(vararg values: Output<String>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("haflpvihohphyslx")
    public suspend fun groups(values: List<Output<String>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value Array of Quicksight user names to assign the policy to.
     */
    @JvmName("ahxbyqpwpplkedfq")
    public suspend fun users(`value`: Output<List<String>>) {
        this.users = value
    }

    @JvmName("yturqnjrlqlauepk")
    public suspend fun users(vararg values: Output<String>) {
        this.users = Output.all(values.asList())
    }

    /**
     * @param values Array of Quicksight user names to assign the policy to.
     */
    @JvmName("fdialtkdlsrnctfp")
    public suspend fun users(values: List<Output<String>>) {
        this.users = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("qcedcpknlotiqycp")
    public suspend fun groups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param values
     */
    @JvmName("cqcixnwmykummaot")
    public suspend fun groups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param value Array of Quicksight user names to assign the policy to.
     */
    @JvmName("lbqcwvwajutokpdq")
    public suspend fun users(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.users = mapped
    }

    /**
     * @param values Array of Quicksight user names to assign the policy to.
     */
    @JvmName("yfifykbvvbwuxttw")
    public suspend fun users(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.users = mapped
    }

    internal fun build(): IamPolicyAssignmentIdentitiesArgs = IamPolicyAssignmentIdentitiesArgs(
        groups = groups,
        users = users,
    )
}
