@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.NamespaceTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property create
 * @property delete
 */
public data class NamespaceTimeoutsArgs(
    public val create: Output<String>? = null,
    public val delete: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.NamespaceTimeoutsArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.NamespaceTimeoutsArgs =
        com.pulumi.aws.quicksight.inputs.NamespaceTimeoutsArgs.builder()
            .create(create?.applyValue({ args0 -> args0 }))
            .delete(delete?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceTimeoutsArgs].
 */
@PulumiTagMarker
public class NamespaceTimeoutsArgsBuilder internal constructor() {
    private var create: Output<String>? = null

    private var delete: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ovehbahdmmpmuvtm")
    public suspend fun create(`value`: Output<String>) {
        this.create = value
    }

    /**
     * @param value
     */
    @JvmName("gvfetusrlakhymgu")
    public suspend fun delete(`value`: Output<String>) {
        this.delete = value
    }

    /**
     * @param value
     */
    @JvmName("gdaevijcpmerbbks")
    public suspend fun create(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.create = mapped
    }

    /**
     * @param value
     */
    @JvmName("lqyqtrdtcaxuqdmo")
    public suspend fun delete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    internal fun build(): NamespaceTimeoutsArgs = NamespaceTimeoutsArgs(
        create = create,
        delete = delete,
    )
}
