@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property interval The interval between scheduled refreshes. Valid values are `MINUTE15`, `MINUTE30`, `HOURLY`, `DAILY`, `WEEKLY` and `MONTHLY`.
 * @property refreshOnDay The [refresh on entity](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ScheduleRefreshOnEntity.html) configuration for weekly or monthly schedules. See refresh_on_day.
 * @property timeOfTheDay The time of day that you want the dataset to refresh. This value is expressed in `HH:MM` format. This field is not required for schedules that refresh hourly.
 * @property timezone The timezone that you want the refresh schedule to use.
 */
public data class RefreshScheduleScheduleScheduleFrequencyArgs(
    public val interval: Output<String>,
    public val refreshOnDay: Output<RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs>? = null,
    public val timeOfTheDay: Output<String>? = null,
    public val timezone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs> {
    override fun toJava():
        com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs =
        com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs.builder()
            .interval(interval.applyValue({ args0 -> args0 }))
            .refreshOnDay(refreshOnDay?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeOfTheDay(timeOfTheDay?.applyValue({ args0 -> args0 }))
            .timezone(timezone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RefreshScheduleScheduleScheduleFrequencyArgs].
 */
@PulumiTagMarker
public class RefreshScheduleScheduleScheduleFrequencyArgsBuilder internal constructor() {
    private var interval: Output<String>? = null

    private var refreshOnDay: Output<RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs>? = null

    private var timeOfTheDay: Output<String>? = null

    private var timezone: Output<String>? = null

    /**
     * @param value The interval between scheduled refreshes. Valid values are `MINUTE15`, `MINUTE30`, `HOURLY`, `DAILY`, `WEEKLY` and `MONTHLY`.
     */
    @JvmName("xdudahirblmtfowm")
    public suspend fun interval(`value`: Output<String>) {
        this.interval = value
    }

    /**
     * @param value The [refresh on entity](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ScheduleRefreshOnEntity.html) configuration for weekly or monthly schedules. See refresh_on_day.
     */
    @JvmName("xcauymgmskalfemt")
    public suspend
    fun refreshOnDay(`value`: Output<RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs>) {
        this.refreshOnDay = value
    }

    /**
     * @param value The time of day that you want the dataset to refresh. This value is expressed in `HH:MM` format. This field is not required for schedules that refresh hourly.
     */
    @JvmName("rsywvhaxelhgufdm")
    public suspend fun timeOfTheDay(`value`: Output<String>) {
        this.timeOfTheDay = value
    }

    /**
     * @param value The timezone that you want the refresh schedule to use.
     */
    @JvmName("tyyuiajddkuqcwsi")
    public suspend fun timezone(`value`: Output<String>) {
        this.timezone = value
    }

    /**
     * @param value The interval between scheduled refreshes. Valid values are `MINUTE15`, `MINUTE30`, `HOURLY`, `DAILY`, `WEEKLY` and `MONTHLY`.
     */
    @JvmName("ghilrqfegdfbgfko")
    public suspend fun interval(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The [refresh on entity](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ScheduleRefreshOnEntity.html) configuration for weekly or monthly schedules. See refresh_on_day.
     */
    @JvmName("fyomyttewjbdxumx")
    public suspend
    fun refreshOnDay(`value`: RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshOnDay = mapped
    }

    /**
     * @param argument The [refresh on entity](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ScheduleRefreshOnEntity.html) configuration for weekly or monthly schedules. See refresh_on_day.
     */
    @JvmName("fcvhbjhyeclnvvts")
    public suspend
    fun refreshOnDay(argument: suspend RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgsBuilder.() -> Unit) {
        val toBeMapped = RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.refreshOnDay = mapped
    }

    /**
     * @param value The time of day that you want the dataset to refresh. This value is expressed in `HH:MM` format. This field is not required for schedules that refresh hourly.
     */
    @JvmName("kjwthpslufqjftng")
    public suspend fun timeOfTheDay(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeOfTheDay = mapped
    }

    /**
     * @param value The timezone that you want the refresh schedule to use.
     */
    @JvmName("lgqkuwuquakyfrte")
    public suspend fun timezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timezone = mapped
    }

    internal fun build(): RefreshScheduleScheduleScheduleFrequencyArgs =
        RefreshScheduleScheduleScheduleFrequencyArgs(
            interval = interval ?: throw PulumiNullFieldException("interval"),
            refreshOnDay = refreshOnDay,
            timeOfTheDay = timeOfTheDay,
            timezone = timezone,
        )
}
