@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.TemplateSourceEntityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sourceAnalysis The source analysis, if it is based on an analysis.. Only one of `source_analysis` or `source_template` should be configured. See source_analysis.
 * @property sourceTemplate The source template, if it is based on an template.. Only one of `source_analysis` or `source_template` should be configured. See source_template.
 */
public data class TemplateSourceEntityArgs(
    public val sourceAnalysis: Output<TemplateSourceEntitySourceAnalysisArgs>? = null,
    public val sourceTemplate: Output<TemplateSourceEntitySourceTemplateArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.TemplateSourceEntityArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.TemplateSourceEntityArgs =
        com.pulumi.aws.quicksight.inputs.TemplateSourceEntityArgs.builder()
            .sourceAnalysis(sourceAnalysis?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceTemplate(
                sourceTemplate?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TemplateSourceEntityArgs].
 */
@PulumiTagMarker
public class TemplateSourceEntityArgsBuilder internal constructor() {
    private var sourceAnalysis: Output<TemplateSourceEntitySourceAnalysisArgs>? = null

    private var sourceTemplate: Output<TemplateSourceEntitySourceTemplateArgs>? = null

    /**
     * @param value The source analysis, if it is based on an analysis.. Only one of `source_analysis` or `source_template` should be configured. See source_analysis.
     */
    @JvmName("xfpyvdblmtqdpmlr")
    public suspend fun sourceAnalysis(`value`: Output<TemplateSourceEntitySourceAnalysisArgs>) {
        this.sourceAnalysis = value
    }

    /**
     * @param value The source template, if it is based on an template.. Only one of `source_analysis` or `source_template` should be configured. See source_template.
     */
    @JvmName("ntiwxtqihtpmjbej")
    public suspend fun sourceTemplate(`value`: Output<TemplateSourceEntitySourceTemplateArgs>) {
        this.sourceTemplate = value
    }

    /**
     * @param value The source analysis, if it is based on an analysis.. Only one of `source_analysis` or `source_template` should be configured. See source_analysis.
     */
    @JvmName("scbikeavplulpdnw")
    public suspend fun sourceAnalysis(`value`: TemplateSourceEntitySourceAnalysisArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAnalysis = mapped
    }

    /**
     * @param argument The source analysis, if it is based on an analysis.. Only one of `source_analysis` or `source_template` should be configured. See source_analysis.
     */
    @JvmName("xktbggnxnoyvjhke")
    public suspend
    fun sourceAnalysis(argument: suspend TemplateSourceEntitySourceAnalysisArgsBuilder.() -> Unit) {
        val toBeMapped = TemplateSourceEntitySourceAnalysisArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sourceAnalysis = mapped
    }

    /**
     * @param value The source template, if it is based on an template.. Only one of `source_analysis` or `source_template` should be configured. See source_template.
     */
    @JvmName("hllhkrdlolfsrkxd")
    public suspend fun sourceTemplate(`value`: TemplateSourceEntitySourceTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceTemplate = mapped
    }

    /**
     * @param argument The source template, if it is based on an template.. Only one of `source_analysis` or `source_template` should be configured. See source_template.
     */
    @JvmName("essouromuhslslra")
    public suspend
    fun sourceTemplate(argument: suspend TemplateSourceEntitySourceTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = TemplateSourceEntitySourceTemplateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sourceTemplate = mapped
    }

    internal fun build(): TemplateSourceEntityArgs = TemplateSourceEntityArgs(
        sourceAnalysis = sourceAnalysis,
        sourceTemplate = sourceTemplate,
    )
}
