@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.TemplateSourceEntitySourceAnalysisArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the resource.
 * @property dataSetReferences A list of dataset references used as placeholders in the template. See data_set_references.
 */
public data class TemplateSourceEntitySourceAnalysisArgs(
    public val arn: Output<String>,
    public val dataSetReferences:
    Output<List<TemplateSourceEntitySourceAnalysisDataSetReferenceArgs>>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.TemplateSourceEntitySourceAnalysisArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.TemplateSourceEntitySourceAnalysisArgs =
        com.pulumi.aws.quicksight.inputs.TemplateSourceEntitySourceAnalysisArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .dataSetReferences(
                dataSetReferences.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TemplateSourceEntitySourceAnalysisArgs].
 */
@PulumiTagMarker
public class TemplateSourceEntitySourceAnalysisArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var dataSetReferences:
        Output<List<TemplateSourceEntitySourceAnalysisDataSetReferenceArgs>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the resource.
     */
    @JvmName("kqcjojftixesanxp")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value A list of dataset references used as placeholders in the template. See data_set_references.
     */
    @JvmName("ppuojaltkuorrbkr")
    public suspend
    fun dataSetReferences(`value`: Output<List<TemplateSourceEntitySourceAnalysisDataSetReferenceArgs>>) {
        this.dataSetReferences = value
    }

    @JvmName("ekxnvqofouosbesw")
    public suspend fun dataSetReferences(
        vararg
        values: Output<TemplateSourceEntitySourceAnalysisDataSetReferenceArgs>,
    ) {
        this.dataSetReferences = Output.all(values.asList())
    }

    /**
     * @param values A list of dataset references used as placeholders in the template. See data_set_references.
     */
    @JvmName("xcbythtdakbpkbyi")
    public suspend
    fun dataSetReferences(values: List<Output<TemplateSourceEntitySourceAnalysisDataSetReferenceArgs>>) {
        this.dataSetReferences = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the resource.
     */
    @JvmName("iedbecxhunrfnkvr")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value A list of dataset references used as placeholders in the template. See data_set_references.
     */
    @JvmName("ykprkbmlrhjotefc")
    public suspend
    fun dataSetReferences(`value`: List<TemplateSourceEntitySourceAnalysisDataSetReferenceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSetReferences = mapped
    }

    /**
     * @param argument A list of dataset references used as placeholders in the template. See data_set_references.
     */
    @JvmName("fivjhyvliicfubnu")
    public suspend
    fun dataSetReferences(argument: List<suspend TemplateSourceEntitySourceAnalysisDataSetReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TemplateSourceEntitySourceAnalysisDataSetReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataSetReferences = mapped
    }

    /**
     * @param argument A list of dataset references used as placeholders in the template. See data_set_references.
     */
    @JvmName("abyuylvindafcilq")
    public suspend fun dataSetReferences(
        vararg
        argument: suspend TemplateSourceEntitySourceAnalysisDataSetReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TemplateSourceEntitySourceAnalysisDataSetReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataSetReferences = mapped
    }

    /**
     * @param argument A list of dataset references used as placeholders in the template. See data_set_references.
     */
    @JvmName("lwpqnfrvsqpymwmt")
    public suspend
    fun dataSetReferences(argument: suspend TemplateSourceEntitySourceAnalysisDataSetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                TemplateSourceEntitySourceAnalysisDataSetReferenceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.dataSetReferences = mapped
    }

    /**
     * @param values A list of dataset references used as placeholders in the template. See data_set_references.
     */
    @JvmName("lwucyyowafduuasn")
    public suspend fun dataSetReferences(
        vararg
        values: TemplateSourceEntitySourceAnalysisDataSetReferenceArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSetReferences = mapped
    }

    internal fun build(): TemplateSourceEntitySourceAnalysisArgs =
        TemplateSourceEntitySourceAnalysisArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            dataSetReferences = dataSetReferences ?: throw PulumiNullFieldException("dataSetReferences"),
        )
}
