@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.TemplateSourceEntitySourceTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the resource.
 */
public data class TemplateSourceEntitySourceTemplateArgs(
    public val arn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.TemplateSourceEntitySourceTemplateArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.TemplateSourceEntitySourceTemplateArgs =
        com.pulumi.aws.quicksight.inputs.TemplateSourceEntitySourceTemplateArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateSourceEntitySourceTemplateArgs].
 */
@PulumiTagMarker
public class TemplateSourceEntitySourceTemplateArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the resource.
     */
    @JvmName("jhixopyvbvmivnpk")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the resource.
     */
    @JvmName("iqvswsqvgjbdrvco")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    internal fun build(): TemplateSourceEntitySourceTemplateArgs =
        TemplateSourceEntitySourceTemplateArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
        )
}
