@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.ThemeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dataColorPalette Color properties that apply to chart data colors. See data_color_palette.
 * @property sheet Display options related to sheets. See sheet.
 * @property typography Determines the typography options. See typography.
 * @property uiColorPalette Color properties that apply to the UI and to charts, excluding the colors that apply to data. See ui_color_palette.
 */
public data class ThemeConfigurationArgs(
    public val dataColorPalette: Output<ThemeConfigurationDataColorPaletteArgs>? = null,
    public val sheet: Output<ThemeConfigurationSheetArgs>? = null,
    public val typography: Output<ThemeConfigurationTypographyArgs>? = null,
    public val uiColorPalette: Output<ThemeConfigurationUiColorPaletteArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.ThemeConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.ThemeConfigurationArgs =
        com.pulumi.aws.quicksight.inputs.ThemeConfigurationArgs.builder()
            .dataColorPalette(dataColorPalette?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sheet(sheet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .typography(typography?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uiColorPalette(
                uiColorPalette?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ThemeConfigurationArgs].
 */
@PulumiTagMarker
public class ThemeConfigurationArgsBuilder internal constructor() {
    private var dataColorPalette: Output<ThemeConfigurationDataColorPaletteArgs>? = null

    private var sheet: Output<ThemeConfigurationSheetArgs>? = null

    private var typography: Output<ThemeConfigurationTypographyArgs>? = null

    private var uiColorPalette: Output<ThemeConfigurationUiColorPaletteArgs>? = null

    /**
     * @param value Color properties that apply to chart data colors. See data_color_palette.
     */
    @JvmName("lyihhlfpwhtsbqgo")
    public suspend fun dataColorPalette(`value`: Output<ThemeConfigurationDataColorPaletteArgs>) {
        this.dataColorPalette = value
    }

    /**
     * @param value Display options related to sheets. See sheet.
     */
    @JvmName("yhaulhgedqetcvnf")
    public suspend fun sheet(`value`: Output<ThemeConfigurationSheetArgs>) {
        this.sheet = value
    }

    /**
     * @param value Determines the typography options. See typography.
     */
    @JvmName("udgcqmwxjrykrbyj")
    public suspend fun typography(`value`: Output<ThemeConfigurationTypographyArgs>) {
        this.typography = value
    }

    /**
     * @param value Color properties that apply to the UI and to charts, excluding the colors that apply to data. See ui_color_palette.
     */
    @JvmName("gyhetwwilpenfhao")
    public suspend fun uiColorPalette(`value`: Output<ThemeConfigurationUiColorPaletteArgs>) {
        this.uiColorPalette = value
    }

    /**
     * @param value Color properties that apply to chart data colors. See data_color_palette.
     */
    @JvmName("evcdxpihkqxxuhbb")
    public suspend fun dataColorPalette(`value`: ThemeConfigurationDataColorPaletteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataColorPalette = mapped
    }

    /**
     * @param argument Color properties that apply to chart data colors. See data_color_palette.
     */
    @JvmName("ccdpobogmlyawlsg")
    public suspend
    fun dataColorPalette(argument: suspend ThemeConfigurationDataColorPaletteArgsBuilder.() -> Unit) {
        val toBeMapped = ThemeConfigurationDataColorPaletteArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataColorPalette = mapped
    }

    /**
     * @param value Display options related to sheets. See sheet.
     */
    @JvmName("uferroiqlhwxiatg")
    public suspend fun sheet(`value`: ThemeConfigurationSheetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sheet = mapped
    }

    /**
     * @param argument Display options related to sheets. See sheet.
     */
    @JvmName("gepfpsbaxhaifxrn")
    public suspend fun sheet(argument: suspend ThemeConfigurationSheetArgsBuilder.() -> Unit) {
        val toBeMapped = ThemeConfigurationSheetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sheet = mapped
    }

    /**
     * @param value Determines the typography options. See typography.
     */
    @JvmName("frwshoiltmvgjrwe")
    public suspend fun typography(`value`: ThemeConfigurationTypographyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typography = mapped
    }

    /**
     * @param argument Determines the typography options. See typography.
     */
    @JvmName("nywjqjpnocxhqncn")
    public suspend
    fun typography(argument: suspend ThemeConfigurationTypographyArgsBuilder.() -> Unit) {
        val toBeMapped = ThemeConfigurationTypographyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.typography = mapped
    }

    /**
     * @param value Color properties that apply to the UI and to charts, excluding the colors that apply to data. See ui_color_palette.
     */
    @JvmName("ttjhoblbxyrtotms")
    public suspend fun uiColorPalette(`value`: ThemeConfigurationUiColorPaletteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uiColorPalette = mapped
    }

    /**
     * @param argument Color properties that apply to the UI and to charts, excluding the colors that apply to data. See ui_color_palette.
     */
    @JvmName("mcbkqovvjlaucegb")
    public suspend
    fun uiColorPalette(argument: suspend ThemeConfigurationUiColorPaletteArgsBuilder.() -> Unit) {
        val toBeMapped = ThemeConfigurationUiColorPaletteArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.uiColorPalette = mapped
    }

    internal fun build(): ThemeConfigurationArgs = ThemeConfigurationArgs(
        dataColorPalette = dataColorPalette,
        sheet = sheet,
        typography = typography,
        uiColorPalette = uiColorPalette,
    )
}
