@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.ThemeConfigurationTypographyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fontFamilies Determines the list of font families. Maximum number of 5 items. See font_families.
 */
public data class ThemeConfigurationTypographyArgs(
    public val fontFamilies: Output<List<ThemeConfigurationTypographyFontFamilyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.ThemeConfigurationTypographyArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.ThemeConfigurationTypographyArgs =
        com.pulumi.aws.quicksight.inputs.ThemeConfigurationTypographyArgs.builder()
            .fontFamilies(
                fontFamilies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ThemeConfigurationTypographyArgs].
 */
@PulumiTagMarker
public class ThemeConfigurationTypographyArgsBuilder internal constructor() {
    private var fontFamilies: Output<List<ThemeConfigurationTypographyFontFamilyArgs>>? = null

    /**
     * @param value Determines the list of font families. Maximum number of 5 items. See font_families.
     */
    @JvmName("sqtksikptsgvhbmc")
    public suspend
    fun fontFamilies(`value`: Output<List<ThemeConfigurationTypographyFontFamilyArgs>>) {
        this.fontFamilies = value
    }

    @JvmName("wlotetoudlwljpvw")
    public suspend fun fontFamilies(
        vararg
        values: Output<ThemeConfigurationTypographyFontFamilyArgs>,
    ) {
        this.fontFamilies = Output.all(values.asList())
    }

    /**
     * @param values Determines the list of font families. Maximum number of 5 items. See font_families.
     */
    @JvmName("slassfcmijywawcg")
    public suspend
    fun fontFamilies(values: List<Output<ThemeConfigurationTypographyFontFamilyArgs>>) {
        this.fontFamilies = Output.all(values)
    }

    /**
     * @param value Determines the list of font families. Maximum number of 5 items. See font_families.
     */
    @JvmName("exyplkndwxasnyog")
    public suspend fun fontFamilies(`value`: List<ThemeConfigurationTypographyFontFamilyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fontFamilies = mapped
    }

    /**
     * @param argument Determines the list of font families. Maximum number of 5 items. See font_families.
     */
    @JvmName("fewleonpgckstgcl")
    public suspend
    fun fontFamilies(argument: List<suspend ThemeConfigurationTypographyFontFamilyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThemeConfigurationTypographyFontFamilyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fontFamilies = mapped
    }

    /**
     * @param argument Determines the list of font families. Maximum number of 5 items. See font_families.
     */
    @JvmName("svpanxbyqtrtgmss")
    public suspend fun fontFamilies(
        vararg
        argument: suspend ThemeConfigurationTypographyFontFamilyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ThemeConfigurationTypographyFontFamilyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.fontFamilies = mapped
    }

    /**
     * @param argument Determines the list of font families. Maximum number of 5 items. See font_families.
     */
    @JvmName("jhtcdtmmehgtfjrn")
    public suspend
    fun fontFamilies(argument: suspend ThemeConfigurationTypographyFontFamilyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ThemeConfigurationTypographyFontFamilyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.fontFamilies = mapped
    }

    /**
     * @param values Determines the list of font families. Maximum number of 5 items. See font_families.
     */
    @JvmName("tgimyxetcnmoferg")
    public suspend fun fontFamilies(vararg values: ThemeConfigurationTypographyFontFamilyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fontFamilies = mapped
    }

    internal fun build(): ThemeConfigurationTypographyArgs = ThemeConfigurationTypographyArgs(
        fontFamilies = fontFamilies,
    )
}
